/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"split_index", "splitindex"}, parameter="(String str, String delimiter, Integer index)", descriptions={"- Return \"\" if the index is negative or any of the arguments is NULL;", "- Return \"\" NULL if the index is out of bounds of the split strings;", "- Return the string at the given 'index' integer(zero-based) after splitting 'str' by 'delimiter'."}, examples={"split_index('a,b,c', ',', 1) = \"b\""})
public class SplitIndexFunction
implements ValueParser {
    private final ValueParser strParser;
    private final ValueParser delimiterParser;
    private final ValueParser indexParser;

    public SplitIndexFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.strParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.delimiterParser = OperatorTools.buildParser((Expression)expressions.get(1));
        this.indexParser = OperatorTools.buildParser((Expression)expressions.get(2));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object strObject = this.strParser.parse(sourceData, rowIndex, context);
        Object delimiterObject = this.delimiterParser.parse(sourceData, rowIndex, context);
        Object indexObject = this.indexParser.parse(sourceData, rowIndex, context);
        if (strObject == null || delimiterObject == null || indexObject == null) {
            return null;
        }
        String str = OperatorTools.parseString(strObject);
        String delimiter = OperatorTools.parseString(delimiterObject);
        int index = OperatorTools.parseBigDecimal(indexObject).intValue();
        if (str == null || delimiter == null || index < 0) {
            return null;
        }
        String[] splitStrings = str.split(delimiter);
        if (index >= splitStrings.length) {
            return null;
        }
        return splitStrings[index];
    }
}

