/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster.tubemq;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.cluster.tubemq.TubeClusterRequest;

@ApiModel(value="TubeMQ cluster info")
public class TubeClusterDTO {
    @NotBlank(message="masterWebUrl cannot be blank")
    @ApiModelProperty(value="Master Web URL http://120.0.0.1:8080", notes="TubeMQ master RPC URL is the 'url' field of the cluster")
    private @NotBlank(message="masterWebUrl cannot be blank") String masterWebUrl;
    private String messageQueueHandler;
    @JsonProperty(value="master-host-port-list")
    private String masterIpPortList;

    public static TubeClusterDTO getFromRequest(TubeClusterRequest request, String extParams) {
        TubeClusterDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? TubeClusterDTO.getFromJson(extParams) : new TubeClusterDTO();
        return (TubeClusterDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static TubeClusterDTO getFromJson(@NotNull String extParams) {
        try {
            return (TubeClusterDTO)JsonUtils.parseObject((String)extParams, TubeClusterDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, String.format("parse extParams of TubeMQ Cluster failure: %s", e.getMessage()));
        }
    }

    private static String $default$messageQueueHandler() {
        return "org.apache.inlong.dataproxy.sink.mq.tube.TubeHandler";
    }

    public static TubeClusterDTOBuilder builder() {
        return new TubeClusterDTOBuilder();
    }

    public String getMasterWebUrl() {
        return this.masterWebUrl;
    }

    public String getMessageQueueHandler() {
        return this.messageQueueHandler;
    }

    public String getMasterIpPortList() {
        return this.masterIpPortList;
    }

    public void setMasterWebUrl(String masterWebUrl) {
        this.masterWebUrl = masterWebUrl;
    }

    public void setMessageQueueHandler(String messageQueueHandler) {
        this.messageQueueHandler = messageQueueHandler;
    }

    @JsonProperty(value="master-host-port-list")
    public void setMasterIpPortList(String masterIpPortList) {
        this.masterIpPortList = masterIpPortList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TubeClusterDTO)) {
            return false;
        }
        TubeClusterDTO other = (TubeClusterDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$masterWebUrl = this.getMasterWebUrl();
        String other$masterWebUrl = other.getMasterWebUrl();
        if (this$masterWebUrl == null ? other$masterWebUrl != null : !this$masterWebUrl.equals(other$masterWebUrl)) {
            return false;
        }
        String this$messageQueueHandler = this.getMessageQueueHandler();
        String other$messageQueueHandler = other.getMessageQueueHandler();
        if (this$messageQueueHandler == null ? other$messageQueueHandler != null : !this$messageQueueHandler.equals(other$messageQueueHandler)) {
            return false;
        }
        String this$masterIpPortList = this.getMasterIpPortList();
        String other$masterIpPortList = other.getMasterIpPortList();
        return !(this$masterIpPortList == null ? other$masterIpPortList != null : !this$masterIpPortList.equals(other$masterIpPortList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TubeClusterDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $masterWebUrl = this.getMasterWebUrl();
        result = result * 59 + ($masterWebUrl == null ? 43 : $masterWebUrl.hashCode());
        String $messageQueueHandler = this.getMessageQueueHandler();
        result = result * 59 + ($messageQueueHandler == null ? 43 : $messageQueueHandler.hashCode());
        String $masterIpPortList = this.getMasterIpPortList();
        result = result * 59 + ($masterIpPortList == null ? 43 : $masterIpPortList.hashCode());
        return result;
    }

    public String toString() {
        return "TubeClusterDTO(masterWebUrl=" + this.getMasterWebUrl() + ", messageQueueHandler=" + this.getMessageQueueHandler() + ", masterIpPortList=" + this.getMasterIpPortList() + ")";
    }

    public TubeClusterDTO() {
        this.messageQueueHandler = TubeClusterDTO.$default$messageQueueHandler();
    }

    public TubeClusterDTO(String masterWebUrl, String messageQueueHandler, String masterIpPortList) {
        this.masterWebUrl = masterWebUrl;
        this.messageQueueHandler = messageQueueHandler;
        this.masterIpPortList = masterIpPortList;
    }

    public static class TubeClusterDTOBuilder {
        private String masterWebUrl;
        private boolean messageQueueHandler$set;
        private String messageQueueHandler$value;
        private String masterIpPortList;

        TubeClusterDTOBuilder() {
        }

        public TubeClusterDTOBuilder masterWebUrl(String masterWebUrl) {
            this.masterWebUrl = masterWebUrl;
            return this;
        }

        public TubeClusterDTOBuilder messageQueueHandler(String messageQueueHandler) {
            this.messageQueueHandler$value = messageQueueHandler;
            this.messageQueueHandler$set = true;
            return this;
        }

        @JsonProperty(value="master-host-port-list")
        public TubeClusterDTOBuilder masterIpPortList(String masterIpPortList) {
            this.masterIpPortList = masterIpPortList;
            return this;
        }

        public TubeClusterDTO build() {
            String messageQueueHandler$value = this.messageQueueHandler$value;
            if (!this.messageQueueHandler$set) {
                messageQueueHandler$value = TubeClusterDTO.$default$messageQueueHandler();
            }
            return new TubeClusterDTO(this.masterWebUrl, messageQueueHandler$value, this.masterIpPortList);
        }

        public String toString() {
            return "TubeClusterDTO.TubeClusterDTOBuilder(masterWebUrl=" + this.masterWebUrl + ", messageQueueHandler$value=" + this.messageQueueHandler$value + ", masterIpPortList=" + this.masterIpPortList + ")";
        }
    }
}

