/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.http;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.node.http.HttpDataNodeRequest;

@ApiModel(value="Http service data node info")
public class HttpDataNodeDTO {
    @ApiModelProperty(value="HTTP base url")
    private String baseUrl;
    @ApiModelProperty(value="Whether to enable credential")
    private Boolean enableCredential;
    @ApiModelProperty(value="Max connect count")
    private Integer maxConnect;

    public static HttpDataNodeDTO getFromRequest(HttpDataNodeRequest request, String extParams) {
        HttpDataNodeDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? HttpDataNodeDTO.getFromJson(extParams) : new HttpDataNodeDTO();
        return (HttpDataNodeDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static HttpDataNodeDTO getFromJson(@NotNull String extParams) {
        try {
            return (HttpDataNodeDTO)JsonUtils.parseObject((String)extParams, HttpDataNodeDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.GROUP_INFO_INCORRECT, String.format("Failed to parse extParams for Cloud log service node: %s", e.getMessage()));
        }
    }

    public static HttpDataNodeDTOBuilder builder() {
        return new HttpDataNodeDTOBuilder();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Boolean getEnableCredential() {
        return this.enableCredential;
    }

    public Integer getMaxConnect() {
        return this.maxConnect;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setEnableCredential(Boolean enableCredential) {
        this.enableCredential = enableCredential;
    }

    public void setMaxConnect(Integer maxConnect) {
        this.maxConnect = maxConnect;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpDataNodeDTO)) {
            return false;
        }
        HttpDataNodeDTO other = (HttpDataNodeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enableCredential = this.getEnableCredential();
        Boolean other$enableCredential = other.getEnableCredential();
        if (this$enableCredential == null ? other$enableCredential != null : !((Object)this$enableCredential).equals(other$enableCredential)) {
            return false;
        }
        Integer this$maxConnect = this.getMaxConnect();
        Integer other$maxConnect = other.getMaxConnect();
        if (this$maxConnect == null ? other$maxConnect != null : !((Object)this$maxConnect).equals(other$maxConnect)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        return !(this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpDataNodeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enableCredential = this.getEnableCredential();
        result = result * 59 + ($enableCredential == null ? 43 : ((Object)$enableCredential).hashCode());
        Integer $maxConnect = this.getMaxConnect();
        result = result * 59 + ($maxConnect == null ? 43 : ((Object)$maxConnect).hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        return result;
    }

    public String toString() {
        return "HttpDataNodeDTO(baseUrl=" + this.getBaseUrl() + ", enableCredential=" + this.getEnableCredential() + ", maxConnect=" + this.getMaxConnect() + ")";
    }

    public HttpDataNodeDTO() {
    }

    public HttpDataNodeDTO(String baseUrl, Boolean enableCredential, Integer maxConnect) {
        this.baseUrl = baseUrl;
        this.enableCredential = enableCredential;
        this.maxConnect = maxConnect;
    }

    public static class HttpDataNodeDTOBuilder {
        private String baseUrl;
        private Boolean enableCredential;
        private Integer maxConnect;

        HttpDataNodeDTOBuilder() {
        }

        public HttpDataNodeDTOBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public HttpDataNodeDTOBuilder enableCredential(Boolean enableCredential) {
            this.enableCredential = enableCredential;
            return this;
        }

        public HttpDataNodeDTOBuilder maxConnect(Integer maxConnect) {
            this.maxConnect = maxConnect;
            return this;
        }

        public HttpDataNodeDTO build() {
            return new HttpDataNodeDTO(this.baseUrl, this.enableCredential, this.maxConnect);
        }

        public String toString() {
            return "HttpDataNodeDTO.HttpDataNodeDTOBuilder(baseUrl=" + this.baseUrl + ", enableCredential=" + this.enableCredential + ", maxConnect=" + this.maxConnect + ")";
        }
    }
}

