/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.postgresql;

import io.swagger.annotations.ApiModel;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.node.postgresql.PostgreSQLDataNodeRequest;

@ApiModel(value="PostgreSQL data node info")
public class PostgreSQLDataNodeDTO {
    private static final String POSTGRESQL_JDBC_PREFIX = "jdbc:postgresql://";

    public static PostgreSQLDataNodeDTO getFromRequest(PostgreSQLDataNodeRequest request, String extParams) {
        PostgreSQLDataNodeDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? PostgreSQLDataNodeDTO.getFromJson(extParams) : new PostgreSQLDataNodeDTO();
        return (PostgreSQLDataNodeDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static PostgreSQLDataNodeDTO getFromJson(@NotNull String extParams) {
        try {
            return (PostgreSQLDataNodeDTO)JsonUtils.parseObject((String)extParams, PostgreSQLDataNodeDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.GROUP_INFO_INCORRECT, String.format("Failed to parse extParams for PostgreSQL node: %s", e.getMessage()));
        }
    }

    public static String convertToJdbcUrl(String url) {
        String jdbcUrl = url;
        if (StringUtils.isNotBlank((CharSequence)jdbcUrl) && !jdbcUrl.startsWith(POSTGRESQL_JDBC_PREFIX)) {
            jdbcUrl = POSTGRESQL_JDBC_PREFIX + jdbcUrl;
        }
        return jdbcUrl;
    }

    PostgreSQLDataNodeDTO() {
    }

    public static PostgreSQLDataNodeDTOBuilder builder() {
        return new PostgreSQLDataNodeDTOBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostgreSQLDataNodeDTO)) {
            return false;
        }
        PostgreSQLDataNodeDTO other = (PostgreSQLDataNodeDTO)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostgreSQLDataNodeDTO;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "PostgreSQLDataNodeDTO()";
    }

    public static class PostgreSQLDataNodeDTOBuilder {
        PostgreSQLDataNodeDTOBuilder() {
        }

        public PostgreSQLDataNodeDTO build() {
            return new PostgreSQLDataNodeDTO();
        }

        public String toString() {
            return "PostgreSQLDataNodeDTO.PostgreSQLDataNodeDTOBuilder()";
        }
    }
}

