/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.cls;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.BaseStreamSink;
import org.apache.inlong.manager.pojo.sink.cls.ClsSinkRequest;

public class ClsSinkDTO
extends BaseStreamSink {
    @ApiModelProperty(value="Cloud log service topic id")
    private String topicId;
    @ApiModelProperty(value="Cloud log service topic name")
    private String topicName;
    @ApiModelProperty(value="Cloud log service topic storage duration")
    private Integer storageDuration;
    @ApiModelProperty(value="Cloud log service tag name")
    private String tag;
    @ApiModelProperty(value="Cloud log service index tokenizer")
    private String tokenizer;
    @ApiModelProperty(value="contentOffset")
    private Integer contentOffset = 0;
    @ApiModelProperty(value="fieldOffset")
    private Integer fieldOffset;
    @ApiModelProperty(value="separator")
    private String separator;

    public static ClsSinkDTO getFromRequest(ClsSinkRequest request, String extParams) {
        ClsSinkDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? ClsSinkDTO.getFromJson(extParams) : new ClsSinkDTO();
        return (ClsSinkDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static ClsSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return (ClsSinkDTO)JsonUtils.parseObject((String)extParams, ClsSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of CLS SinkDTO failure: %s", e.getMessage()));
        }
    }

    public static ClsSinkDTOBuilder builder() {
        return new ClsSinkDTOBuilder();
    }

    public String getTopicId() {
        return this.topicId;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public Integer getStorageDuration() {
        return this.storageDuration;
    }

    public String getTag() {
        return this.tag;
    }

    public String getTokenizer() {
        return this.tokenizer;
    }

    public Integer getContentOffset() {
        return this.contentOffset;
    }

    public Integer getFieldOffset() {
        return this.fieldOffset;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setStorageDuration(Integer storageDuration) {
        this.storageDuration = storageDuration;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setTokenizer(String tokenizer) {
        this.tokenizer = tokenizer;
    }

    public void setContentOffset(Integer contentOffset) {
        this.contentOffset = contentOffset;
    }

    public void setFieldOffset(Integer fieldOffset) {
        this.fieldOffset = fieldOffset;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClsSinkDTO)) {
            return false;
        }
        ClsSinkDTO other = (ClsSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$storageDuration = this.getStorageDuration();
        Integer other$storageDuration = other.getStorageDuration();
        if (this$storageDuration == null ? other$storageDuration != null : !((Object)this$storageDuration).equals(other$storageDuration)) {
            return false;
        }
        Integer this$contentOffset = this.getContentOffset();
        Integer other$contentOffset = other.getContentOffset();
        if (this$contentOffset == null ? other$contentOffset != null : !((Object)this$contentOffset).equals(other$contentOffset)) {
            return false;
        }
        Integer this$fieldOffset = this.getFieldOffset();
        Integer other$fieldOffset = other.getFieldOffset();
        if (this$fieldOffset == null ? other$fieldOffset != null : !((Object)this$fieldOffset).equals(other$fieldOffset)) {
            return false;
        }
        String this$topicId = this.getTopicId();
        String other$topicId = other.getTopicId();
        if (this$topicId == null ? other$topicId != null : !this$topicId.equals(other$topicId)) {
            return false;
        }
        String this$topicName = this.getTopicName();
        String other$topicName = other.getTopicName();
        if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$tokenizer = this.getTokenizer();
        String other$tokenizer = other.getTokenizer();
        if (this$tokenizer == null ? other$tokenizer != null : !this$tokenizer.equals(other$tokenizer)) {
            return false;
        }
        String this$separator = this.getSeparator();
        String other$separator = other.getSeparator();
        return !(this$separator == null ? other$separator != null : !this$separator.equals(other$separator));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ClsSinkDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $storageDuration = this.getStorageDuration();
        result = result * 59 + ($storageDuration == null ? 43 : ((Object)$storageDuration).hashCode());
        Integer $contentOffset = this.getContentOffset();
        result = result * 59 + ($contentOffset == null ? 43 : ((Object)$contentOffset).hashCode());
        Integer $fieldOffset = this.getFieldOffset();
        result = result * 59 + ($fieldOffset == null ? 43 : ((Object)$fieldOffset).hashCode());
        String $topicId = this.getTopicId();
        result = result * 59 + ($topicId == null ? 43 : $topicId.hashCode());
        String $topicName = this.getTopicName();
        result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $tokenizer = this.getTokenizer();
        result = result * 59 + ($tokenizer == null ? 43 : $tokenizer.hashCode());
        String $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : $separator.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ClsSinkDTO(topicId=" + this.getTopicId() + ", topicName=" + this.getTopicName() + ", storageDuration=" + this.getStorageDuration() + ", tag=" + this.getTag() + ", tokenizer=" + this.getTokenizer() + ", contentOffset=" + this.getContentOffset() + ", fieldOffset=" + this.getFieldOffset() + ", separator=" + this.getSeparator() + ")";
    }

    public ClsSinkDTO() {
    }

    public ClsSinkDTO(String topicId, String topicName, Integer storageDuration, String tag, String tokenizer, Integer contentOffset, Integer fieldOffset, String separator) {
        this.topicId = topicId;
        this.topicName = topicName;
        this.storageDuration = storageDuration;
        this.tag = tag;
        this.tokenizer = tokenizer;
        this.contentOffset = contentOffset;
        this.fieldOffset = fieldOffset;
        this.separator = separator;
    }

    public static class ClsSinkDTOBuilder {
        private String topicId;
        private String topicName;
        private Integer storageDuration;
        private String tag;
        private String tokenizer;
        private Integer contentOffset;
        private Integer fieldOffset;
        private String separator;

        ClsSinkDTOBuilder() {
        }

        public ClsSinkDTOBuilder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public ClsSinkDTOBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public ClsSinkDTOBuilder storageDuration(Integer storageDuration) {
            this.storageDuration = storageDuration;
            return this;
        }

        public ClsSinkDTOBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public ClsSinkDTOBuilder tokenizer(String tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public ClsSinkDTOBuilder contentOffset(Integer contentOffset) {
            this.contentOffset = contentOffset;
            return this;
        }

        public ClsSinkDTOBuilder fieldOffset(Integer fieldOffset) {
            this.fieldOffset = fieldOffset;
            return this;
        }

        public ClsSinkDTOBuilder separator(String separator) {
            this.separator = separator;
            return this;
        }

        public ClsSinkDTO build() {
            return new ClsSinkDTO(this.topicId, this.topicName, this.storageDuration, this.tag, this.tokenizer, this.contentOffset, this.fieldOffset, this.separator);
        }

        public String toString() {
            return "ClsSinkDTO.ClsSinkDTOBuilder(topicId=" + this.topicId + ", topicName=" + this.topicName + ", storageDuration=" + this.storageDuration + ", tag=" + this.tag + ", tokenizer=" + this.tokenizer + ", contentOffset=" + this.contentOffset + ", fieldOffset=" + this.fieldOffset + ", separator=" + this.separator + ")";
        }
    }
}

