/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.mqtt;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.source.mqtt.MqttSourceRequest;

public class MqttSourceDTO {
    @ApiModelProperty(value="ServerURI of the Mqtt server")
    private String serverURI;
    @ApiModelProperty(value="Username of the Mqtt server")
    private String username;
    @ApiModelProperty(value="Password of the Mqtt server")
    private String password;
    @ApiModelProperty(value="Topic of the Mqtt server")
    private String topic;
    @ApiModelProperty(value="Mqtt qos")
    private int qos = 1;
    @ApiModelProperty(value="Client Id")
    private String clientId;
    @ApiModelProperty(value="Mqtt version")
    private String mqttVersion;

    public static MqttSourceDTO getFromRequest(MqttSourceRequest request, String extParams) {
        MqttSourceDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? MqttSourceDTO.getFromJson(extParams) : new MqttSourceDTO();
        return (MqttSourceDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static MqttSourceDTO getFromJson(@NotNull String extParams) {
        try {
            return (MqttSourceDTO)JsonUtils.parseObject((String)extParams, MqttSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("parse extParams of MqttSource failure: %s", e.getMessage()));
        }
    }

    public static MqttSourceDTOBuilder builder() {
        return new MqttSourceDTOBuilder();
    }

    public String getServerURI() {
        return this.serverURI;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getQos() {
        return this.qos;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getMqttVersion() {
        return this.mqttVersion;
    }

    public void setServerURI(String serverURI) {
        this.serverURI = serverURI;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setQos(int qos) {
        this.qos = qos;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setMqttVersion(String mqttVersion) {
        this.mqttVersion = mqttVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MqttSourceDTO)) {
            return false;
        }
        MqttSourceDTO other = (MqttSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getQos() != other.getQos()) {
            return false;
        }
        String this$serverURI = this.getServerURI();
        String other$serverURI = other.getServerURI();
        if (this$serverURI == null ? other$serverURI != null : !this$serverURI.equals(other$serverURI)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$mqttVersion = this.getMqttVersion();
        String other$mqttVersion = other.getMqttVersion();
        return !(this$mqttVersion == null ? other$mqttVersion != null : !this$mqttVersion.equals(other$mqttVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MqttSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getQos();
        String $serverURI = this.getServerURI();
        result = result * 59 + ($serverURI == null ? 43 : $serverURI.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $mqttVersion = this.getMqttVersion();
        result = result * 59 + ($mqttVersion == null ? 43 : $mqttVersion.hashCode());
        return result;
    }

    public String toString() {
        return "MqttSourceDTO(serverURI=" + this.getServerURI() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", topic=" + this.getTopic() + ", qos=" + this.getQos() + ", clientId=" + this.getClientId() + ", mqttVersion=" + this.getMqttVersion() + ")";
    }

    public MqttSourceDTO() {
    }

    public MqttSourceDTO(String serverURI, String username, String password, String topic, int qos, String clientId, String mqttVersion) {
        this.serverURI = serverURI;
        this.username = username;
        this.password = password;
        this.topic = topic;
        this.qos = qos;
        this.clientId = clientId;
        this.mqttVersion = mqttVersion;
    }

    public static class MqttSourceDTOBuilder {
        private String serverURI;
        private String username;
        private String password;
        private String topic;
        private int qos;
        private String clientId;
        private String mqttVersion;

        MqttSourceDTOBuilder() {
        }

        public MqttSourceDTOBuilder serverURI(String serverURI) {
            this.serverURI = serverURI;
            return this;
        }

        public MqttSourceDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public MqttSourceDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public MqttSourceDTOBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public MqttSourceDTOBuilder qos(int qos) {
            this.qos = qos;
            return this;
        }

        public MqttSourceDTOBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public MqttSourceDTOBuilder mqttVersion(String mqttVersion) {
            this.mqttVersion = mqttVersion;
            return this;
        }

        public MqttSourceDTO build() {
            return new MqttSourceDTO(this.serverURI, this.username, this.password, this.topic, this.qos, this.clientId, this.mqttVersion);
        }

        public String toString() {
            return "MqttSourceDTO.MqttSourceDTOBuilder(serverURI=" + this.serverURI + ", username=" + this.username + ", password=" + this.password + ", topic=" + this.topic + ", qos=" + this.qos + ", clientId=" + this.clientId + ", mqttVersion=" + this.mqttVersion + ")";
        }
    }
}

