/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.stream;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.apache.inlong.manager.pojo.common.PageRequest;

@ApiModel(value="Inlong stream paging query request")
public class InlongStreamPageRequest
extends PageRequest {
    @ApiModelProperty(value="Inlong group id")
    private String inlongGroupId;
    @ApiModelProperty(value="Keyword, can be stream id or name")
    private String keyword;
    @ApiModelProperty(value="status")
    private Integer status;
    @ApiModelProperty(value="Stream status list")
    private List<Integer> statusList;
    @ApiModelProperty(value="Inlong group in charge")
    private String inCharge;
    @ApiModelProperty(value="Current user", hidden=true)
    private String currentUser;
    @ApiModelProperty(value="weather is admin role.", hidden=true)
    private Boolean isAdminRole;

    public static InlongStreamPageRequestBuilder builder() {
        return new InlongStreamPageRequestBuilder();
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public Integer getStatus() {
        return this.status;
    }

    public List<Integer> getStatusList() {
        return this.statusList;
    }

    public String getInCharge() {
        return this.inCharge;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public Boolean getIsAdminRole() {
        return this.isAdminRole;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setStatusList(List<Integer> statusList) {
        this.statusList = statusList;
    }

    public void setInCharge(String inCharge) {
        this.inCharge = inCharge;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    public void setIsAdminRole(Boolean isAdminRole) {
        this.isAdminRole = isAdminRole;
    }

    public String toString() {
        return "InlongStreamPageRequest(inlongGroupId=" + this.getInlongGroupId() + ", keyword=" + this.getKeyword() + ", status=" + this.getStatus() + ", statusList=" + this.getStatusList() + ", inCharge=" + this.getInCharge() + ", currentUser=" + this.getCurrentUser() + ", isAdminRole=" + this.getIsAdminRole() + ")";
    }

    public InlongStreamPageRequest() {
    }

    public InlongStreamPageRequest(String inlongGroupId, String keyword, Integer status, List<Integer> statusList, String inCharge, String currentUser, Boolean isAdminRole) {
        this.inlongGroupId = inlongGroupId;
        this.keyword = keyword;
        this.status = status;
        this.statusList = statusList;
        this.inCharge = inCharge;
        this.currentUser = currentUser;
        this.isAdminRole = isAdminRole;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongStreamPageRequest)) {
            return false;
        }
        InlongStreamPageRequest other = (InlongStreamPageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Boolean this$isAdminRole = this.getIsAdminRole();
        Boolean other$isAdminRole = other.getIsAdminRole();
        if (this$isAdminRole == null ? other$isAdminRole != null : !((Object)this$isAdminRole).equals(other$isAdminRole)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
            return false;
        }
        List<Integer> this$statusList = this.getStatusList();
        List<Integer> other$statusList = other.getStatusList();
        if (this$statusList == null ? other$statusList != null : !((Object)this$statusList).equals(other$statusList)) {
            return false;
        }
        String this$inCharge = this.getInCharge();
        String other$inCharge = other.getInCharge();
        if (this$inCharge == null ? other$inCharge != null : !this$inCharge.equals(other$inCharge)) {
            return false;
        }
        String this$currentUser = this.getCurrentUser();
        String other$currentUser = other.getCurrentUser();
        return !(this$currentUser == null ? other$currentUser != null : !this$currentUser.equals(other$currentUser));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlongStreamPageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Boolean $isAdminRole = this.getIsAdminRole();
        result = result * 59 + ($isAdminRole == null ? 43 : ((Object)$isAdminRole).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        List<Integer> $statusList = this.getStatusList();
        result = result * 59 + ($statusList == null ? 43 : ((Object)$statusList).hashCode());
        String $inCharge = this.getInCharge();
        result = result * 59 + ($inCharge == null ? 43 : $inCharge.hashCode());
        String $currentUser = this.getCurrentUser();
        result = result * 59 + ($currentUser == null ? 43 : $currentUser.hashCode());
        return result;
    }

    public static class InlongStreamPageRequestBuilder {
        private String inlongGroupId;
        private String keyword;
        private Integer status;
        private List<Integer> statusList;
        private String inCharge;
        private String currentUser;
        private Boolean isAdminRole;

        InlongStreamPageRequestBuilder() {
        }

        public InlongStreamPageRequestBuilder inlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
            return this;
        }

        public InlongStreamPageRequestBuilder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public InlongStreamPageRequestBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public InlongStreamPageRequestBuilder statusList(List<Integer> statusList) {
            this.statusList = statusList;
            return this;
        }

        public InlongStreamPageRequestBuilder inCharge(String inCharge) {
            this.inCharge = inCharge;
            return this;
        }

        public InlongStreamPageRequestBuilder currentUser(String currentUser) {
            this.currentUser = currentUser;
            return this;
        }

        public InlongStreamPageRequestBuilder isAdminRole(Boolean isAdminRole) {
            this.isAdminRole = isAdminRole;
            return this;
        }

        public InlongStreamPageRequest build() {
            return new InlongStreamPageRequest(this.inlongGroupId, this.keyword, this.status, this.statusList, this.inCharge, this.currentUser, this.isAdminRole);
        }

        public String toString() {
            return "InlongStreamPageRequest.InlongStreamPageRequestBuilder(inlongGroupId=" + this.inlongGroupId + ", keyword=" + this.keyword + ", status=" + this.status + ", statusList=" + this.statusList + ", inCharge=" + this.inCharge + ", currentUser=" + this.currentUser + ", isAdminRole=" + this.isAdminRole + ")";
        }
    }
}

