/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.stream;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.apache.inlong.manager.common.validation.SaveValidation;
import org.apache.inlong.manager.pojo.stream.TemplateField;

@ApiModel(value="Inlong template info")
public class TemplateInfo {
    @ApiModelProperty(value="Primary key")
    private Integer id;
    @ApiModelProperty(value="Template name")
    @NotBlank(groups={SaveValidation.class}, message="template name cannot be blank")
    private @NotBlank(groups={SaveValidation.class}, message="template name cannot be blank") String name;
    @ApiModelProperty(value="Name of responsible person, separated by commas")
    private String inCharges;
    @ApiModelProperty(value="Visible range for template")
    private String visibleRange;
    @ApiModelProperty(value="Field list")
    private List<TemplateField> fieldList;
    @ApiModelProperty(value="Bind tenants")
    private List<String> tenantList;
    @ApiModelProperty(value="Name of in creator")
    private String creator;
    @ApiModelProperty(value="Name of in modifier")
    private String modifier;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
    private Date createTime;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
    private Date modifyTime;
    @ApiModelProperty(value="Version number")
    private Integer version;

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public String getVisibleRange() {
        return this.visibleRange;
    }

    public List<TemplateField> getFieldList() {
        return this.fieldList;
    }

    public List<String> getTenantList() {
        return this.tenantList;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setVisibleRange(String visibleRange) {
        this.visibleRange = visibleRange;
    }

    public void setFieldList(List<TemplateField> fieldList) {
        this.fieldList = fieldList;
    }

    public void setTenantList(List<String> tenantList) {
        this.tenantList = tenantList;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateInfo)) {
            return false;
        }
        TemplateInfo other = (TemplateInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        if (this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges)) {
            return false;
        }
        String this$visibleRange = this.getVisibleRange();
        String other$visibleRange = other.getVisibleRange();
        if (this$visibleRange == null ? other$visibleRange != null : !this$visibleRange.equals(other$visibleRange)) {
            return false;
        }
        List<TemplateField> this$fieldList = this.getFieldList();
        List<TemplateField> other$fieldList = other.getFieldList();
        if (this$fieldList == null ? other$fieldList != null : !((Object)this$fieldList).equals(other$fieldList)) {
            return false;
        }
        List<String> this$tenantList = this.getTenantList();
        List<String> other$tenantList = other.getTenantList();
        if (this$tenantList == null ? other$tenantList != null : !((Object)this$tenantList).equals(other$tenantList)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        return !(this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TemplateInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        String $visibleRange = this.getVisibleRange();
        result = result * 59 + ($visibleRange == null ? 43 : $visibleRange.hashCode());
        List<TemplateField> $fieldList = this.getFieldList();
        result = result * 59 + ($fieldList == null ? 43 : ((Object)$fieldList).hashCode());
        List<String> $tenantList = this.getTenantList();
        result = result * 59 + ($tenantList == null ? 43 : ((Object)$tenantList).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        return result;
    }

    public String toString() {
        return "TemplateInfo(id=" + this.getId() + ", name=" + this.getName() + ", inCharges=" + this.getInCharges() + ", visibleRange=" + this.getVisibleRange() + ", fieldList=" + this.getFieldList() + ", tenantList=" + this.getTenantList() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ", version=" + this.getVersion() + ")";
    }
}

