/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.consumer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.inlong.tubemq.client.consumer.MessageListener;
import org.apache.inlong.tubemq.client.consumer.TopicProcessor;

public class ClientSubInfo {
    private final ConcurrentHashMap<String, TopicProcessor> topicCondRegistry = new ConcurrentHashMap();
    private boolean requireBound = false;
    private AtomicBoolean isNotAllocated = new AtomicBoolean(true);
    private int sourceCount = -1;
    private String sessionKey;
    private long subscribedTime;
    private boolean isSelectBig = true;
    private String requiredPartition = "";
    private Set<String> subscribedTopics = new HashSet<String>();
    private Map<String, Long> assignedPartMap = new HashMap<String, Long>();
    private Map<String, Boolean> topicFilterMap = new HashMap<String, Boolean>();

    public boolean getIsNotAllocated() {
        return this.isNotAllocated.get();
    }

    public boolean compareAndSetIsNotAllocated(boolean expect, boolean update) {
        return this.isNotAllocated.compareAndSet(expect, update);
    }

    public boolean isSubscribedTopicEmpty() {
        return this.subscribedTopics.isEmpty();
    }

    public boolean isSubscribedTopicContain(String topic) {
        return this.subscribedTopics.contains(topic);
    }

    public TopicProcessor getTopicProcessor(String topic) {
        return this.topicCondRegistry.get(topic);
    }

    public void storeConsumeTarget(Map<String, TreeSet<String>> consumeTarget) {
        for (Map.Entry<String, TreeSet<String>> entry : consumeTarget.entrySet()) {
            TopicProcessor topicProcessor = new TopicProcessor(null, entry.getValue());
            this.topicCondRegistry.put(entry.getKey(), topicProcessor);
            this.subscribedTopics.add(entry.getKey());
            this.topicFilterMap.put(entry.getKey(), entry.getValue() != null && !entry.getValue().isEmpty());
        }
        this.requireBound = false;
        this.subscribedTime = System.currentTimeMillis();
    }

    public TopicProcessor putIfAbsentTopicProcessor(String topic, TopicProcessor topicProcessor) {
        TopicProcessor topicProcessor1 = this.topicCondRegistry.putIfAbsent(topic, topicProcessor);
        if (topicProcessor1 == null) {
            this.subscribedTopics.add(topic);
            Set<String> condSet = topicProcessor.getFilterConds();
            this.topicFilterMap.put(topic, condSet != null && !condSet.isEmpty());
        }
        return topicProcessor1;
    }

    public void notifyAllMessageListenerStopped() {
        for (Map.Entry<String, TopicProcessor> entry : this.topicCondRegistry.entrySet()) {
            MessageListener listener;
            if (entry.getValue() == null || (listener = entry.getValue().getMessageListener()) == null) continue;
            listener.stop();
        }
        this.topicCondRegistry.clear();
    }

    public int getSourceCount() {
        return this.sourceCount;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public long getSubscribedTime() {
        return this.subscribedTime;
    }

    public boolean isSelectBig() {
        return this.isSelectBig;
    }

    public boolean isRequireBound() {
        return this.requireBound;
    }

    public boolean isFilterConsume(String topic) {
        Boolean ret = this.topicFilterMap.get(topic);
        if (ret == null) {
            return false;
        }
        return ret;
    }

    public void setNotRequireBound() {
        this.requireBound = false;
        this.subscribedTime = System.currentTimeMillis();
    }

    public void setRequireBound(String sessionKey, int sourceCount, boolean isSelectBig, Map<String, Long> partOffsetMap) {
        this.requireBound = true;
        this.subscribedTime = System.currentTimeMillis();
        this.sessionKey = sessionKey;
        this.isSelectBig = isSelectBig;
        this.sourceCount = sourceCount;
        int count = 0;
        StringBuilder sBuilder = new StringBuilder(256);
        for (Map.Entry<String, Long> entry : partOffsetMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.assignedPartMap.put(entry.getKey().trim(), entry.getValue());
            if (count++ > 0) {
                sBuilder.append(",");
            }
            sBuilder.append(entry.getKey().trim()).append("=").append(entry.getValue());
        }
        this.requiredPartition = sBuilder.toString();
    }

    public String getRequiredPartition() {
        return this.requiredPartition;
    }

    public Set<String> getSubscribedTopics() {
        return this.subscribedTopics;
    }

    public Map<String, Long> getAssignedPartMap() {
        return this.assignedPartMap;
    }

    public Long getAssignedPartOffset(String partitionKey) {
        return this.assignedPartMap.get(partitionKey);
    }

    public ConcurrentHashMap<String, TopicProcessor> getTopicCondRegistry() {
        return this.topicCondRegistry;
    }
}

