/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.store.service.consume;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.audit.store.config.MessageQueueConfig;
import org.apache.inlong.audit.store.config.StoreConfig;
import org.apache.inlong.audit.store.service.InsertData;
import org.apache.inlong.audit.store.service.consume.BaseConsume;
import org.apache.inlong.audit.store.service.consume.KafkaConsume;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsume
extends BaseConsume {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaConsume.class);
    private KafkaConsumer<String, byte[]> consumer;
    private String serverUrl;
    private String topic;
    private static final int DEFAULT_NUM_PARTITIONS = 3;
    private static final int DEFAULT_REPLICATION_FACTOR = 2;

    public KafkaConsume(List<InsertData> insertServiceList, StoreConfig storeConfig, MessageQueueConfig mqConfig) {
        super(insertServiceList, storeConfig, mqConfig);
    }

    public void start() {
        this.serverUrl = this.mqConfig.getKafkaServerUrl();
        this.topic = this.mqConfig.getKafkaTopic();
        boolean isAutoCommit = Boolean.getBoolean(this.mqConfig.getEnableAutoCommit());
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.serverUrl), (Object)"no kafka server url specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.mqConfig.getKafkaTopic()), (Object)"no kafka topic topic specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.mqConfig.getKafkaConsumerName()), (Object)"no kafka consume name specified");
        this.createTopic();
        this.initConsumer(this.mqConfig);
        Thread thread = new Thread((Runnable)new Fetcher(this, this.consumer, this.topic, isAutoCommit, this.mqConfig.getFetchWaitMs()), "KafkaConsume_Fetcher_Thread");
        thread.start();
    }

    private void createTopic() {
        int numPartitions = 3;
        if (StringUtils.isNotEmpty((CharSequence)this.mqConfig.getNumPartitions())) {
            numPartitions = Integer.parseInt(this.mqConfig.getNumPartitions());
        }
        int replicationFactor = 2;
        if (StringUtils.isNotEmpty((CharSequence)this.mqConfig.getReplicationFactor())) {
            replicationFactor = Integer.parseInt(this.mqConfig.getReplicationFactor());
        }
        try (AdminClient adminClient = AdminClient.create((Properties)this.getProperties(this.mqConfig));){
            ListTopicsResult topicList = adminClient.listTopics();
            KafkaFuture kafkaFuture = topicList.names();
            Set topicSet = (Set)kafkaFuture.get();
            if (topicSet.contains(this.topic)) {
                LOG.info("The audit topic:{} already exists.", (Object)this.topic);
                return;
            }
            DescribeClusterResult describeClusterResult = adminClient.describeCluster();
            Collection nodes = (Collection)describeClusterResult.nodes().get();
            if (nodes.isEmpty()) {
                throw new IllegalArgumentException("kafka server not find");
            }
            int partition = Math.min(numPartitions, nodes.size());
            int factor = Math.min(replicationFactor, nodes.size());
            NewTopic needCreateTopic = new NewTopic(this.topic, partition, (short)factor);
            CreateTopicsResult createTopicsResult = adminClient.createTopics(Collections.singletonList(needCreateTopic));
            createTopicsResult.all().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(String.format("create audit topic:%s error with config:%s", this.topic, this.getProperties(this.mqConfig)), e);
        }
    }

    protected void initConsumer(MessageQueueConfig mqConfig) {
        LOG.info("init kafka consumer, topic:{}, serverUrl:{}", (Object)this.topic, (Object)this.serverUrl);
        Properties properties = this.getProperties(mqConfig);
        this.consumer = new KafkaConsumer(properties);
        this.consumer.subscribe(Collections.singleton(this.topic));
    }

    private Properties getProperties(MessageQueueConfig mqConfig) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.serverUrl);
        properties.put("group.id", mqConfig.getKafkaGroupId());
        properties.put("enable.auto.commit", mqConfig.getEnableAutoCommit());
        properties.put("auto.commit.interval.ms", mqConfig.getAutoCommitIntervalMs());
        properties.put("auto.offset.reset", mqConfig.getAutoOffsetReset());
        properties.put("key.deserializer", StringDeserializer.class.getName());
        properties.put("value.deserializer", ByteArrayDeserializer.class.getName());
        return properties;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

