/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.entities;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.inlong.audit.service.config.Configuration;

public class PartitionEntity {
    private final String tableName;
    private final String addPartitionStatement;
    private final String deletePartitionStatement;
    private final DateTimeFormatter FORMATTER_YYMMDDHH = DateTimeFormatter.ofPattern("yyyyMMdd");
    private final DateTimeFormatter FORMATTER_YY_MM_DD_HH = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private String formatPartitionName(LocalDate date) {
        return "p" + date.format(this.FORMATTER_YYMMDDHH);
    }

    public PartitionEntity(String tableName, String addPartitionStatement, String deletePartitionStatement) {
        this.tableName = tableName;
        this.addPartitionStatement = addPartitionStatement;
        this.deletePartitionStatement = deletePartitionStatement;
    }

    public String getAddPartitionSql(long daysToAdd) {
        String partitionValue = LocalDate.now().plusDays(daysToAdd + 1L).format(this.FORMATTER_YY_MM_DD_HH);
        return String.format(this.addPartitionStatement, this.getAddPartitionName(daysToAdd), partitionValue);
    }

    public String getDeletePartitionSql(long daysToDelete) {
        return String.format(this.deletePartitionStatement, this.getDeletePartitionName(daysToDelete));
    }

    public String getCheckPartitionSql(long partitionDay, boolean isDelete) {
        String partitionName = isDelete ? this.getDeletePartitionName(partitionDay) : this.getAddPartitionName(partitionDay);
        return String.format(Configuration.getInstance().get("audit.data.check.partition.sql", "SELECT COUNT(*) AS count FROM INFORMATION_SCHEMA.PARTITIONS WHERE TABLE_NAME = '%s' and PARTITION_NAME = '%s'"), this.tableName, partitionName);
    }

    public String getAddPartitionName(long daysToAdd) {
        return this.formatPartitionName(LocalDate.now().plusDays(daysToAdd));
    }

    public String getDeletePartitionName(long daysToDelete) {
        return this.formatPartitionName(LocalDate.now().minusDays(daysToDelete));
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getAddPartitionStatement() {
        return this.addPartitionStatement;
    }

    public String getDeletePartitionStatement() {
        return this.deletePartitionStatement;
    }

    public DateTimeFormatter getFORMATTER_YYMMDDHH() {
        return this.FORMATTER_YYMMDDHH;
    }

    public DateTimeFormatter getFORMATTER_YY_MM_DD_HH() {
        return this.FORMATTER_YY_MM_DD_HH;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartitionEntity)) {
            return false;
        }
        PartitionEntity other = (PartitionEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$addPartitionStatement = this.getAddPartitionStatement();
        String other$addPartitionStatement = other.getAddPartitionStatement();
        if (this$addPartitionStatement == null ? other$addPartitionStatement != null : !this$addPartitionStatement.equals(other$addPartitionStatement)) {
            return false;
        }
        String this$deletePartitionStatement = this.getDeletePartitionStatement();
        String other$deletePartitionStatement = other.getDeletePartitionStatement();
        if (this$deletePartitionStatement == null ? other$deletePartitionStatement != null : !this$deletePartitionStatement.equals(other$deletePartitionStatement)) {
            return false;
        }
        DateTimeFormatter this$FORMATTER_YYMMDDHH = this.getFORMATTER_YYMMDDHH();
        DateTimeFormatter other$FORMATTER_YYMMDDHH = other.getFORMATTER_YYMMDDHH();
        if (this$FORMATTER_YYMMDDHH == null ? other$FORMATTER_YYMMDDHH != null : !this$FORMATTER_YYMMDDHH.equals(other$FORMATTER_YYMMDDHH)) {
            return false;
        }
        DateTimeFormatter this$FORMATTER_YY_MM_DD_HH = this.getFORMATTER_YY_MM_DD_HH();
        DateTimeFormatter other$FORMATTER_YY_MM_DD_HH = other.getFORMATTER_YY_MM_DD_HH();
        return !(this$FORMATTER_YY_MM_DD_HH == null ? other$FORMATTER_YY_MM_DD_HH != null : !this$FORMATTER_YY_MM_DD_HH.equals(other$FORMATTER_YY_MM_DD_HH));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartitionEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $addPartitionStatement = this.getAddPartitionStatement();
        result = result * 59 + ($addPartitionStatement == null ? 43 : $addPartitionStatement.hashCode());
        String $deletePartitionStatement = this.getDeletePartitionStatement();
        result = result * 59 + ($deletePartitionStatement == null ? 43 : $deletePartitionStatement.hashCode());
        DateTimeFormatter $FORMATTER_YYMMDDHH = this.getFORMATTER_YYMMDDHH();
        result = result * 59 + ($FORMATTER_YYMMDDHH == null ? 43 : $FORMATTER_YYMMDDHH.hashCode());
        DateTimeFormatter $FORMATTER_YY_MM_DD_HH = this.getFORMATTER_YY_MM_DD_HH();
        result = result * 59 + ($FORMATTER_YY_MM_DD_HH == null ? 43 : $FORMATTER_YY_MM_DD_HH.hashCode());
        return result;
    }

    public String toString() {
        return "PartitionEntity(tableName=" + this.getTableName() + ", addPartitionStatement=" + this.getAddPartitionStatement() + ", deletePartitionStatement=" + this.getDeletePartitionStatement() + ", FORMATTER_YYMMDDHH=" + this.getFORMATTER_YYMMDDHH() + ", FORMATTER_YY_MM_DD_HH=" + this.getFORMATTER_YY_MM_DD_HH() + ")";
    }
}

