/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.node;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.inlong.audit.service.config.Configuration;
import org.apache.inlong.audit.service.entities.JdbcConfig;
import org.apache.inlong.audit.service.utils.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigService.class);
    private static volatile ConfigService configService = null;
    private CopyOnWriteArrayList<String> auditIds = new CopyOnWriteArrayList();
    protected final ScheduledExecutorService updateTimer = Executors.newSingleThreadScheduledExecutor();
    private DataSource dataSource;
    private ConcurrentHashMap<String, List<JdbcConfig>> auditSources = new ConcurrentHashMap();
    private final String queryAuditIdSql = Configuration.getInstance().get("mysql.query.audit.id.sql", "select audit_id from audit_id_config where status=1 ");
    private final String queryAuditSourceSql = Configuration.getInstance().get("mysql.query.audit.source.sql", "select jdbc_driver_class, jdbc_url, jdbc_user_name, jdbc_password, service_id from audit_source_config where status=1 ");
    private final String DEFAULT_AUDIT_IDS = "3;4;5;6";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigService getInstance() {
        if (configService != null) return configService;
        Class<ConfigService> clazz = ConfigService.class;
        synchronized (ConfigService.class) {
            if (configService != null) return configService;
            configService = new ConfigService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return configService;
        }
    }

    private ConfigService() {
    }

    public void start() {
        this.createDataSource();
        this.updateTimer.scheduleWithFixedDelay((Runnable)new /* Unavailable Anonymous Inner Class!! */, 0L, Configuration.getInstance().get("config.update.interval.seconds", 60), TimeUnit.SECONDS);
    }

    private void createDataSource() {
        JdbcConfig jdbcConfig = JdbcUtils.buildMysqlConfig();
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(jdbcConfig.getDriverClass());
        config.setJdbcUrl(jdbcConfig.getJdbcUrl());
        config.setUsername(jdbcConfig.getUserName());
        config.setPassword(jdbcConfig.getPassword());
        config.setConnectionTimeout((long)Configuration.getInstance().get("datasource.connection.timeout.ms", 300000));
        config.addDataSourceProperty("cachePrepStmts", (Object)Configuration.getInstance().get("cache.prep.stmts", true));
        config.addDataSourceProperty("prepStmtCacheSize", (Object)Configuration.getInstance().get("prep.stmt.cache.size", 250));
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)Configuration.getInstance().get("prep.stmt.cache.sql.limit", 2048));
        config.setMaximumPoolSize(Configuration.getInstance().get("datasource.pool.size", 2));
        this.dataSource = new HikariDataSource(config);
    }

    private void updateAuditIds() {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement pstat = connection.prepareStatement(this.queryAuditIdSql);){
            if (connection.isClosed()) {
                this.createDataSource();
            }
            try (ResultSet resultSet = pstat.executeQuery();){
                CopyOnWriteArrayList<String> auditIdsTemp = new CopyOnWriteArrayList<String>();
                while (resultSet.next()) {
                    String auditId = resultSet.getString(1);
                    LOGGER.info("Update audit id {}", (Object)auditId);
                    auditIdsTemp.add(auditId);
                }
                if (!auditIdsTemp.isEmpty()) {
                    this.auditIds = auditIdsTemp;
                }
            }
            catch (SQLException sqlException) {
                LOGGER.error("Query has SQL exception! ", (Throwable)sqlException);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Query has exception! ", (Throwable)exception);
        }
        if (this.auditIds.isEmpty()) {
            this.auditIds.addAll(Arrays.asList("3;4;5;6".split(";")));
            LOGGER.info("The default audit item is used: {}", (Object)"3;4;5;6");
        }
    }

    private void updateAuditSource() {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement pstat = connection.prepareStatement(this.queryAuditSourceSql);){
            if (connection.isClosed()) {
                this.createDataSource();
            }
            try (ResultSet resultSet = pstat.executeQuery();){
                ConcurrentHashMap<String, List> auditSourcesTemp = new ConcurrentHashMap<String, List>();
                while (resultSet.next()) {
                    JdbcConfig data = new JdbcConfig(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4));
                    String serviceId = resultSet.getString(5);
                    List config = auditSourcesTemp.computeIfAbsent(serviceId, k -> new LinkedList());
                    config.add(data);
                    LOGGER.info("Update audit source service id = {}, jdbc config = {}", (Object)serviceId, (Object)data);
                }
                if (!auditSourcesTemp.isEmpty()) {
                    this.auditSources = auditSourcesTemp;
                }
            }
            catch (SQLException sqlException) {
                LOGGER.error("Query has SQL exception! ", (Throwable)sqlException);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Query has exception! ", (Throwable)exception);
        }
        if (this.auditSources.isEmpty()) {
            this.auditSources.put(Configuration.getInstance().get("selector.service.id", "audit-service"), Collections.singletonList(JdbcUtils.buildMysqlConfig()));
            LOGGER.info("The default audit data source is used,the same as the audit service.");
        }
    }

    public List<String> getAuditIds() {
        this.auditIds = this.auditIds == null ? new CopyOnWriteArrayList<String>() : this.auditIds;
        return this.auditIds;
    }

    public List<JdbcConfig> getAllAuditSource() {
        LinkedList<JdbcConfig> sourceList = new LinkedList<JdbcConfig>();
        for (Map.Entry entry : this.auditSources.entrySet()) {
            sourceList.addAll((Collection)entry.getValue());
        }
        return sourceList;
    }

    public List<JdbcConfig> getAuditSourceByServiceId(String serviceId) {
        return (List)this.auditSources.get(serviceId);
    }

    static /* synthetic */ void access$000(ConfigService x0) {
        x0.updateAuditIds();
    }

    static /* synthetic */ void access$100(ConfigService x0) {
        x0.updateAuditSource();
    }
}

