/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.node;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.LinkedList;
import java.util.List;
import org.apache.inlong.audit.service.cache.HalfHourCache;
import org.apache.inlong.audit.service.cache.HourCache;
import org.apache.inlong.audit.service.cache.TenMinutesCache;
import org.apache.inlong.audit.service.channel.DataQueue;
import org.apache.inlong.audit.service.config.Configuration;
import org.apache.inlong.audit.service.entities.AuditCycle;
import org.apache.inlong.audit.service.entities.JdbcConfig;
import org.apache.inlong.audit.service.entities.SinkConfig;
import org.apache.inlong.audit.service.entities.SourceConfig;
import org.apache.inlong.audit.service.entities.StatData;
import org.apache.inlong.audit.service.node.ConfigService;
import org.apache.inlong.audit.service.sink.AuditSink;
import org.apache.inlong.audit.service.sink.CacheSink;
import org.apache.inlong.audit.service.sink.JdbcSink;
import org.apache.inlong.audit.service.source.JdbcSource;
import org.apache.inlong.audit.service.utils.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtlService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtlService.class);
    private final List<JdbcSource> originalSources = new LinkedList();
    private final int queueSize;
    private final String serviceId;
    private final Configuration configuration;
    private final List<JdbcSource> dataFlowSources = new LinkedList();
    private final List<AuditSink> dataFlowSinks = new LinkedList();

    public EtlService() {
        this.configuration = Configuration.getInstance();
        this.queueSize = this.configuration.get("data.queue.size", 1000000);
        this.serviceId = this.configuration.get("selector.service.id", "audit-service");
    }

    public void start() {
        int statBackTimes = this.configuration.get("summary.realtime.stat.back.times", 6);
        if (this.configuration.get("enable.stat.audit.minute.10", true)) {
            this.startDataFlow(AuditCycle.MINUTE_10, statBackTimes, TenMinutesCache.getInstance().getCache());
            LOGGER.info("Start data flow for minute 10");
        }
        if (this.configuration.get("enable.stat.audit.minute.30", true)) {
            this.startDataFlow(AuditCycle.MINUTE_30, statBackTimes, HalfHourCache.getInstance().getCache());
            LOGGER.info("Start data flow for minute 30");
        }
        if (this.configuration.get("enable.stat.audit.hour", true)) {
            this.startDataFlow(AuditCycle.HOUR, statBackTimes, HourCache.getInstance().getCache());
            LOGGER.info("Start data flow for hour");
        }
        if (this.configuration.get("enable.stat.audit.day", true)) {
            statBackTimes = this.configuration.get("summary.daily.stat.back.times", 2);
            this.startDataFlow(AuditCycle.DAY, statBackTimes, null);
        }
    }

    private void startDataFlow(AuditCycle cycle, int backTimes, Cache<String, StatData> cache) {
        CacheSink sink;
        DataQueue dataQueue = new DataQueue(this.queueSize);
        JdbcSource source = new JdbcSource(dataQueue, this.buildMysqlSourceConfig(cycle, backTimes));
        source.start();
        this.dataFlowSources.add(source);
        if (cache != null) {
            sink = new CacheSink(dataQueue, cache);
        } else {
            SinkConfig sinkConfig = this.buildMysqlSinkConfig(this.configuration.get("mysql.sink.insert.day.sql", "replace into audit_data_day (log_ts,inlong_group_id, inlong_stream_id, audit_id,audit_tag,count, size, delay)  values (?,?,?,?,?,?,?,?)"));
            sink = new JdbcSink(dataQueue, sinkConfig);
        }
        sink.start();
        this.dataFlowSinks.add(sink);
    }

    public void auditSourceToMysql() {
        DataQueue dataQueue = new DataQueue(this.queueSize);
        List sourceList = ConfigService.getInstance().getAuditSourceByServiceId(this.serviceId);
        for (JdbcConfig jdbcConfig : sourceList) {
            JdbcSource jdbcSource = new JdbcSource(dataQueue, this.buildAuditJdbcSourceConfig(jdbcConfig));
            jdbcSource.start();
            this.originalSources.add(jdbcSource);
            LOGGER.info("Audit source to mysql jdbc config:{}", (Object)jdbcConfig);
        }
        SinkConfig sinkConfig = this.buildMysqlSinkConfig(this.configuration.get("mysql.sink.insert.temp.sql", "replace into audit_data_temp (log_ts,inlong_group_id, inlong_stream_id, audit_id,audit_tag,count, size, delay)  values (?,?,?,?,?,?,?,?)"));
        JdbcSink sink = new JdbcSink(dataQueue, sinkConfig);
        sink.start();
        this.dataFlowSinks.add(sink);
    }

    private SinkConfig buildMysqlSinkConfig(String insertSql) {
        JdbcConfig jdbcConfig = JdbcUtils.buildMysqlConfig();
        return new SinkConfig(insertSql, jdbcConfig.getDriverClass(), jdbcConfig.getJdbcUrl(), jdbcConfig.getUserName(), jdbcConfig.getPassword());
    }

    private SourceConfig buildMysqlSourceConfig(AuditCycle auditCycle, int statBackTimes) {
        JdbcConfig jdbcConfig = JdbcUtils.buildMysqlConfig();
        return new SourceConfig(auditCycle, this.configuration.get("mysql.query.temp.sql", "SELECT inlong_group_id, inlong_stream_id, audit_id, audit_tag\n, sum(count) AS cnt, sum(size) AS size\n, sum(delay) AS delay\nFROM audit_data_temp\nWHERE log_ts >= ? AND log_ts < ? \nAND audit_id = ? \nGROUP BY inlong_group_id, inlong_stream_id, audit_id, audit_tag"), statBackTimes, jdbcConfig.getDriverClass(), jdbcConfig.getJdbcUrl(), jdbcConfig.getUserName(), jdbcConfig.getPassword());
    }

    private SourceConfig buildAuditJdbcSourceConfig(JdbcConfig jdbcConfig) {
        return new SourceConfig(AuditCycle.MINUTE_5, this.configuration.get("source.stat.sql", "SELECT inlong_group_id, inlong_stream_id, audit_id, audit_tag\n\t, SUM(cnt) AS cnt, SUM(size) AS size\n\t, SUM(delay) AS delay\nFROM (\n\tSELECT t_all_version.log_ts, t_all_version.inlong_group_id, t_all_version.inlong_stream_id, t_all_version.audit_id, t_all_version.audit_tag\n\t\t, t_all_version.cnt, t_all_version.size, t_all_version.delay\n\tFROM (\n\t\tSELECT audit_version, log_ts, inlong_group_id, inlong_stream_id, audit_id\n\t\t\t, CASE \n    WHEN audit_tag = '' THEN '-1'\n    ELSE audit_tag\nEND AS audit_tag , SUM(count) AS cnt, SUM(size) AS size\n\t\t\t, SUM(delay) AS delay\n\t\tFROM audit_data\n\t\tWHERE log_ts >= ? AND log_ts < ? \n\t\t\tAND audit_id = ?\n\t\tGROUP BY audit_version, log_ts, inlong_group_id, inlong_stream_id, audit_id, audit_tag\n\t) t_all_version\n\t\tJOIN (\n\t\t\tSELECT max(audit_version) AS audit_version, log_ts, inlong_group_id, inlong_stream_id\n\t\t\t\t, audit_id, CASE \n    WHEN audit_tag = '' THEN '-1'\n    ELSE audit_tag\nEND AS audit_tag \n\t\t\tFROM audit_data\n\t\t\tWHERE log_ts >= ? AND log_ts < ? \n\t\t\t\tAND audit_id = ?\n\t\t\tGROUP BY log_ts, inlong_group_id, inlong_stream_id, audit_id, audit_tag\n\t\t) t_max_version\n\t\tON t_all_version.audit_version = t_max_version.audit_version\n\t\t\tAND t_all_version.log_ts = t_max_version.log_ts\n\t\t\tAND t_all_version.inlong_group_id = t_max_version.inlong_group_id\n\t\t\tAND t_all_version.inlong_stream_id = t_max_version.inlong_stream_id\n\t\t\tAND t_all_version.audit_id = t_max_version.audit_id\n\t\t\tAND t_all_version.audit_tag = t_max_version.audit_tag\n) t_sum\nGROUP BY inlong_group_id, inlong_stream_id, audit_id, audit_tag"), this.configuration.get("summary.realtime.stat.back.times", 6), jdbcConfig.getDriverClass(), jdbcConfig.getJdbcUrl(), jdbcConfig.getUserName(), jdbcConfig.getPassword(), true);
    }

    public void stop() {
        for (JdbcSource source : this.originalSources) {
            source.destroy();
        }
        for (JdbcSource source : this.dataFlowSources) {
            source.destroy();
        }
        for (AuditSink sink : this.dataFlowSinks) {
            sink.destroy();
        }
    }
}

