/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.selector.task;

import java.util.concurrent.TimeUnit;
import org.apache.inlong.audit.service.selector.api.SelectorConfig;
import org.apache.inlong.audit.service.selector.impl.DBDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBMonitorTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBMonitorTask.class);
    private final SelectorConfig selectorConfig;
    private final DBDataSource dbDataSource;
    private int dbClosedTimes = 0;
    private final boolean replaced = true;

    public DBMonitorTask(SelectorConfig selectorConfig, DBDataSource dbDataSource) {
        this.selectorConfig = selectorConfig;
        this.dbDataSource = dbDataSource;
    }

    @Override
    public void run() {
        try {
            do {
                LOGGER.info("DB monitor task run once");
                TimeUnit.SECONDS.sleep(this.selectorConfig.getDbMonitorRunInterval());
            } while (this.selectorConfig.isUseDefaultLeader());
            if (this.dbDataSource.isDBDataSourceClosed()) {
                ++this.dbClosedTimes;
                LOGGER.info("DB closed times :{}", (Object)this.dbClosedTimes);
            } else {
                this.dbClosedTimes = 0;
            }
        }
        catch (Exception e) {
            LOGGER.error("DB monitor task has exception {}", (Object)e.getMessage());
        }
    }
}

