/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.sharedbuffer;

import java.io.IOException;
import java.util.Comparator;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class EventId
implements Comparable<EventId> {
    private final int id;
    private final long timestamp;
    public static final Comparator<EventId> COMPARATOR = Comparator.comparingLong(EventId::getTimestamp).thenComparingInt(EventId::getId);

    public EventId(int id, long timestamp) {
        this.id = id;
        this.timestamp = timestamp;
    }

    public int getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventId eventId = (EventId)o;
        return this.id == eventId.id && this.timestamp == eventId.timestamp;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.timestamp);
    }

    public String toString() {
        return "EventId{id=" + this.id + ", timestamp=" + this.timestamp + '}';
    }

    @Override
    public int compareTo(EventId o) {
        return COMPARATOR.compare(this, o);
    }

    public static class EventIdSerializer
    extends TypeSerializerSingleton<EventId> {
        private static final long serialVersionUID = -5685733582601394497L;
        public static final EventIdSerializer INSTANCE = new EventIdSerializer();

        private EventIdSerializer() {
        }

        public boolean isImmutableType() {
            return true;
        }

        public EventId createInstance() {
            return null;
        }

        public EventId copy(EventId from) {
            return new EventId(from.id, from.timestamp);
        }

        public EventId copy(EventId from, EventId reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return 12;
        }

        public void serialize(EventId record, DataOutputView target) throws IOException {
            target.writeInt(record.id);
            target.writeLong(record.timestamp);
        }

        public EventId deserialize(DataInputView source) throws IOException {
            int id = source.readInt();
            long timestamp = source.readLong();
            return new EventId(id, timestamp);
        }

        public EventId deserialize(EventId reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            target.writeInt(source.readInt());
            target.writeLong(source.readLong());
        }

        public TypeSerializerSnapshot<EventId> snapshotConfiguration() {
            return new EventIdSerializerSnapshot();
        }

        public static final class EventIdSerializerSnapshot
        extends SimpleTypeSerializerSnapshot<EventId> {
            public EventIdSerializerSnapshot() {
                super(() -> INSTANCE);
            }
        }
    }
}

