/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.util.Arrays;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.SimpleResourceDescription;
import org.springframework.hateoas.LinkRelation;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;

public class TypedResourceDescription
extends SimpleResourceDescription {
    private final Class<?> type;

    private TypedResourceDescription(String message, MediaType mediaType, Class<?> type) {
        super(message, mediaType);
        this.type = type == null ? Object.class : type;
    }

    public static ResourceDescription defaultFor(LinkRelation rel, PersistentProperty<?> property) {
        return TypedResourceDescription.defaultFor(rel, property.getName(), property.getType());
    }

    public static ResourceDescription defaultFor(LinkRelation rel, String name, Class<?> type) {
        String message = String.format("%s.%s.%s", "rest.description", rel.value(), name);
        return new TypedResourceDescription(message, DEFAULT_MEDIA_TYPE, type);
    }

    public static ResourceDescription defaultFor(LinkRelation rel, Class<?> type) {
        String message = String.format("%s.%s", "rest.description", rel.value());
        return new TypedResourceDescription(message, DEFAULT_MEDIA_TYPE, type);
    }

    @Override
    public Object[] getArguments() {
        Object[] objectArray;
        if (this.type.isEnum()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.getEnumValues(this.type);
        } else {
            objectArray = new Object[]{};
        }
        return objectArray;
    }

    @Override
    public String getDefaultMessage() {
        return this.type.isEnum() ? this.getEnumValues(this.type) : null;
    }

    private String getEnumValues(Class<?> type) {
        return StringUtils.collectionToDelimitedString(Arrays.asList(type.getEnumConstants()), (String)", ");
    }
}

