/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.channel;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.metrics.AgentMetricItem;
import org.apache.inlong.agent.metrics.AgentMetricItemSet;
import org.apache.inlong.agent.plugin.Channel;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryChannel
implements Channel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryChannel.class);
    private LinkedBlockingQueue<Message> queue;
    private AgentMetricItemSet metricItemSet;
    private static final AtomicLong METRIC_INDEX = new AtomicLong(0L);
    private String inlongGroupId;
    private String inlongStreamId;

    public void push(Message message) {
        try {
            if (message != null) {
                AgentMetricItem metricItem = this.getMetricItem(new HashMap<String, String>());
                metricItem.pluginReadCount.incrementAndGet();
                this.queue.put(message);
                metricItem.pluginReadSuccessCount.incrementAndGet();
            }
        }
        catch (InterruptedException ex) {
            this.metricItemReadFailed();
        }
    }

    public boolean push(Message message, long timeout, TimeUnit unit) {
        try {
            if (message != null) {
                AgentMetricItem metricItem = this.getMetricItem(new HashMap<String, String>());
                metricItem.pluginReadCount.incrementAndGet();
                boolean result = this.queue.offer(message, timeout, unit);
                if (result) {
                    metricItem.pluginReadSuccessCount.incrementAndGet();
                } else {
                    metricItem.pluginReadFailCount.incrementAndGet();
                }
                return result;
            }
        }
        catch (InterruptedException ex) {
            this.metricItemReadFailed();
        }
        return false;
    }

    public Message pull(long timeout, TimeUnit unit) {
        try {
            Message message = this.queue.poll(timeout, unit);
            if (message != null) {
                AgentMetricItem metricItem = this.getMetricItem(new HashMap<String, String>());
                metricItem.pluginSendSuccessCount.incrementAndGet();
                metricItem.pluginSendCount.incrementAndGet();
            }
            return message;
        }
        catch (InterruptedException ex) {
            this.metricItemSendFailed();
            throw new IllegalStateException(ex);
        }
    }

    public void init(JobProfile jobConf) {
        this.inlongGroupId = jobConf.get("proxy.inlongGroupId", "default_inlong_group_id");
        this.inlongStreamId = jobConf.get("proxy.inlongStreamId", "default_inlong_stream_id");
        this.queue = new LinkedBlockingQueue(jobConf.getInt("channel.memory.capacity", 2000));
        String metricName = String.join((CharSequence)"-", this.getClass().getSimpleName(), String.valueOf(METRIC_INDEX.incrementAndGet()));
        this.metricItemSet = new AgentMetricItemSet(metricName);
        MetricRegister.register((MetricItemSet)this.metricItemSet);
    }

    public void destroy() {
        if (this.queue != null) {
            this.queue.clear();
        }
        LOGGER.info("destroy channel, show memory channel metric:");
    }

    private AgentMetricItem getMetricItem(Map<String, String> dimens) {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("pluginId", this.getClass().getSimpleName());
        dimensions.put("inlongGroupId", this.inlongGroupId);
        dimensions.put("inlongStreamId", this.inlongStreamId);
        dimens.forEach((key, value) -> dimensions.put((String)key, (String)value));
        return (AgentMetricItem)this.metricItemSet.findMetricItem(dimensions);
    }

    private void metricItemReadFailed() {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("inlongGroupId", this.inlongGroupId);
        dimensions.put("inlongStreamId", this.inlongStreamId);
        AgentMetricItem metricItem = this.getMetricItem(dimensions);
        metricItem.pluginReadFailCount.incrementAndGet();
        LOGGER.debug("plugin read failed:{}", (Object)((Object)dimensions).toString());
        Thread.currentThread().interrupt();
    }

    private void metricItemSendFailed() {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("inlongGroupId", this.inlongGroupId);
        dimensions.put("inlongStreamId", this.inlongStreamId);
        AgentMetricItem metricItem = this.getMetricItem(dimensions);
        metricItem.pluginSendFailCount.incrementAndGet();
        metricItem.pluginSendCount.incrementAndGet();
        LOGGER.debug("plugin send failed:{}", (Object)((Object)dimensions).toString());
        Thread.currentThread().interrupt();
    }
}

