/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.inlong.agent.plugin.filter.DateFormatRegex;
import org.apache.inlong.agent.utils.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathPattern {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathPattern.class);
    private final String rootDir;
    private final Set<String> subDirs;
    private final Set<DateFormatRegex> whiteList;

    public PathPattern(String rootDir, Set<String> whiteList) {
        this(rootDir, whiteList, null);
    }

    public PathPattern(String rootDir, Set<String> whiteList, String offset) {
        this.rootDir = rootDir;
        this.subDirs = new HashSet<String>();
        if (offset != null && StringUtils.isNotBlank((CharSequence)offset)) {
            this.whiteList = whiteList.stream().map(whiteRegex -> DateFormatRegex.ofRegex(whiteRegex).withOffset(offset)).collect(Collectors.toSet());
            this.updateDateFormatRegex();
        } else {
            this.whiteList = whiteList.stream().map(whiteRegex -> DateFormatRegex.ofRegex(whiteRegex)).collect(Collectors.toSet());
        }
    }

    public static Set<PathPattern> buildPathPattern(Set<String> whiteList, String offset) {
        Set commonWatchDir = PathUtils.findCommonRootPath(whiteList);
        return commonWatchDir.stream().map(rootDir -> {
            Set<String> commonWatchDirWhiteList = whiteList.stream().filter(whiteRegex -> whiteRegex.startsWith((String)rootDir)).collect(Collectors.toSet());
            return new PathPattern((String)rootDir, commonWatchDirWhiteList, offset);
        }).collect(Collectors.toSet());
    }

    public void cleanup() {
        this.subDirs.clear();
    }

    public Collection<File> walkSuitableFiles(int maxNum) {
        ArrayList<File> suitableFiles = new ArrayList<File>();
        this.walkSuitableFiles(suitableFiles, new File(this.rootDir), maxNum);
        return suitableFiles;
    }

    private void walkSuitableFiles(Collection<File> suitableFiles, File file, int maxNum) {
        if (suitableFiles.size() > maxNum) {
            LOGGER.warn("Suitable files exceed max num {}, just return.", (Object)maxNum);
            return;
        }
        if (this.suitable(file.getAbsolutePath())) {
            if (file.isFile()) {
                suitableFiles.add(file);
            } else if (file.isDirectory()) {
                Stream.of(file.listFiles()).forEach(subFile -> this.walkSuitableFiles(suitableFiles, (File)subFile, maxNum));
            }
        }
    }

    public boolean suitable(String path) {
        String briefSubDir = StringUtils.substringAfter((String)path, (String)this.rootDir);
        if (this.subDirs.contains(briefSubDir)) {
            LOGGER.info("already watched {}", (Object)path);
            return false;
        }
        this.subDirs.add(briefSubDir);
        File file = new File(path);
        return this.whiteList.stream().filter(whiteRegex -> whiteRegex.match(file)).findAny().isPresent();
    }

    public void updateDateFormatRegex() {
        this.whiteList.forEach(DateFormatRegex::setRegexWithCurrentTime);
    }

    public void updateDateFormatRegex(String time) {
        this.whiteList.forEach(whiteRegex -> whiteRegex.setRegexWithTime(time));
    }

    public String toString() {
        return this.rootDir;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this.rootDir, (boolean)false);
    }

    public boolean equals(Object object) {
        if (object instanceof PathPattern) {
            PathPattern entity = (PathPattern)object;
            return entity.rootDir.equals(this.rootDir);
        }
        return false;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public String getSuitTime() {
        return ((DateFormatRegex)this.whiteList.stream().findAny().get()).getFormattedTime();
    }
}

