/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task.logcollection;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.core.task.ActionType;
import org.apache.inlong.agent.core.task.OffsetManager;
import org.apache.inlong.agent.core.task.TaskAction;
import org.apache.inlong.agent.plugin.task.AbstractTask;
import org.apache.inlong.agent.plugin.utils.regex.DateUtils;
import org.apache.inlong.agent.plugin.utils.regex.Scanner;
import org.apache.inlong.agent.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogAbstractTask
extends AbstractTask {
    private static final int INSTANCE_QUEUE_CAPACITY = 10;
    public static final long ONE_HOUR_TIMEOUT_INTERVAL_MS = 3600000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LogAbstractTask.class);
    protected boolean retry;
    protected BlockingQueue<InstanceProfile> instanceQueue;
    private volatile boolean runAtLeastOneTime = false;
    protected long startTime;
    protected long endTime;
    protected String timeOffset = "";
    protected final Map<String, Map<String, InstanceProfile>> eventMap = new ConcurrentHashMap<String, Map<String, InstanceProfile>>();

    @Override
    protected void initTask() {
        this.instanceQueue = new LinkedBlockingQueue<InstanceProfile>(10);
    }

    @Override
    protected List<InstanceProfile> getNewInstanceList() {
        if (this.retry) {
            this.runForRetry();
        } else {
            this.runForNormal();
        }
        ArrayList<InstanceProfile> list = new ArrayList<InstanceProfile>();
        while (list.size() < 10 && !this.instanceQueue.isEmpty()) {
            InstanceProfile profile = (InstanceProfile)this.instanceQueue.poll();
            if (profile == null) continue;
            list.add(profile);
        }
        return list;
    }

    protected abstract void runForNormal();

    protected abstract void dealWithEventMap();

    protected abstract void scanExistingFile();

    private void runForRetry() {
        if (!this.runAtLeastOneTime) {
            this.scanExistingFile();
            this.runAtLeastOneTime = true;
        }
        this.dealWithEventMap();
        if (this.allInstanceFinished()) {
            LOGGER.info("retry task finished, send action to task manager, taskId {}", (Object)this.getTaskId());
            TaskAction action = new TaskAction(ActionType.FINISH, this.taskProfile);
            this.taskManager.submitAction(action);
            this.doChangeState(State.SUCCEEDED);
        }
    }

    protected void dealWithEventMapWithCycle() {
        long startScanTime = this.startTime;
        long endScanTime = this.endTime;
        List<String> dataTimeList = Scanner.getDataTimeList(startScanTime, endScanTime, this.taskProfile.getCycleUnit(), this.timeOffset, this.retry);
        if (dataTimeList.isEmpty()) {
            LOGGER.error("getDataTimeList get empty list");
            return;
        }
        HashSet<String> dealtDataTime = new HashSet<String>();
        if (!this.retry) {
            String current = dataTimeList.remove(dataTimeList.size() - 1);
            dealtDataTime.add(current);
            if (!this.dealEventMapByDataTime(current, true)) {
                return;
            }
        }
        dataTimeList.forEach(dataTime -> {
            dealtDataTime.add((String)dataTime);
            if (!this.dealEventMapByDataTime((String)dataTime, false)) {
                return;
            }
        });
        for (String dataTime2 : this.eventMap.keySet()) {
            if (dealtDataTime.contains(dataTime2)) continue;
            this.dealEventMapByDataTime(dataTime2, false);
        }
    }

    protected boolean dealEventMapByDataTime(String dataTime, boolean isCurrentDataTime) {
        Map<String, InstanceProfile> sameDataTimeEvents = this.eventMap.get(dataTime);
        if (sameDataTimeEvents == null || sameDataTimeEvents.isEmpty()) {
            return true;
        }
        if (this.shouldStartNow(dataTime)) {
            TreeSet<InstanceProfile> sortedEvents = new TreeSet<InstanceProfile>(Comparator.comparing(InstanceProfile::getInstanceId));
            sortedEvents.addAll(sameDataTimeEvents.values());
            for (InstanceProfile sortEvent : sortedEvents) {
                String fileName = sortEvent.getInstanceId();
                InstanceProfile profile = sameDataTimeEvents.get(fileName);
                if (!isCurrentDataTime && this.isFull()) {
                    return false;
                }
                if (!this.instanceQueue.offer(profile)) {
                    return false;
                }
                sameDataTimeEvents.remove(fileName);
            }
        }
        return true;
    }

    private boolean shouldStartNow(String dataTime) {
        String shouldStartTime = DateUtils.getShouldStartTime(dataTime, this.taskProfile.getCycleUnit(), this.timeOffset);
        String currentTime = this.getCurrentTime();
        return currentTime.compareTo(shouldStartTime) >= 0;
    }

    private String getCurrentTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        TimeZone timeZone = TimeZone.getTimeZone("Asia/Shanghai");
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(new Date(System.currentTimeMillis()));
    }

    protected void addToEvenMap(String fileName, String dataTime, Long fileUpdateTime, String cycleUnit) {
        if (this.isInEventMap(fileName, dataTime)) {
            LOGGER.info("add to evenMap isInEventMap returns true skip taskId {} dataTime {} fileName {}", new Object[]{this.taskProfile.getTaskId(), dataTime, fileName});
            return;
        }
        if (!this.shouldAddAgain(fileName, fileUpdateTime)) {
            LOGGER.info("add to evenMap shouldAddAgain returns false skip taskId {} dataTime {} fileName {}", new Object[]{this.taskProfile.getTaskId(), dataTime, fileName});
            return;
        }
        Map sameDataTimeEvents = this.eventMap.computeIfAbsent(dataTime, mapKey -> new ConcurrentHashMap());
        boolean containsInMemory = sameDataTimeEvents.containsKey(fileName);
        if (containsInMemory) {
            LOGGER.error("should not happen! may be {} has been deleted and add again", (Object)fileName);
            return;
        }
        InstanceProfile instanceProfile = this.taskProfile.createInstanceProfile(fileName, cycleUnit, dataTime, fileUpdateTime.longValue());
        sameDataTimeEvents.put(fileName, instanceProfile);
        LOGGER.info("add to eventMap taskId {} dataTime {} fileName {}", new Object[]{this.taskProfile.getTaskId(), dataTime, fileName});
    }

    private boolean isInEventMap(String fileName, String dataTime) {
        Map<String, InstanceProfile> fileToProfile = this.eventMap.get(dataTime);
        if (fileToProfile == null) {
            return false;
        }
        return fileToProfile.get(fileName) != null;
    }

    protected void removeTimeoutEvent(Map<String, Map<String, InstanceProfile>> eventMap, boolean isRetry) {
        if (isRetry) {
            return;
        }
        for (Map.Entry<String, Map<String, InstanceProfile>> entry : eventMap.entrySet()) {
            String dataTime = entry.getKey();
            if (DateUtils.isValidCreationTime(dataTime, Math.abs(OffsetManager.getScanCycleRange((String)this.taskProfile.getCycleUnit())) + 3600000L)) continue;
            eventMap.remove(dataTime);
            LOGGER.warn("remove too old event from event map taskId {} dataTime {}", (Object)this.taskProfile.getTaskId(), (Object)dataTime);
        }
    }
}

