/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task.logcollection.cos;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ObjectListing;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.inlong.agent.plugin.utils.regex.PatternUtil;
import org.apache.inlong.agent.plugin.utils.regex.Scanner;
import org.apache.inlong.agent.utils.DateTransUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileScanner {
    public static final int DEFAULT_KEY_COUNT = 100;
    public static final String DEFAULT_DELIMITER = "/";
    public static final char PATH_SEP = '/';
    private static final Logger logger = LoggerFactory.getLogger(FileScanner.class);

    public static List<BasicFileInfo> scanTaskBetweenTimes(COSClient cosClient, String bucketName, String originPattern, String cycleUnit, String timeOffset, long startTime, long endTime, boolean isRetry) {
        List<Scanner.FinalPatternInfo> finalPatternInfos = Scanner.getFinalPatternInfos(originPattern, cycleUnit, timeOffset, startTime, endTime, isRetry);
        ArrayList<BasicFileInfo> infos = new ArrayList<BasicFileInfo>();
        for (Scanner.FinalPatternInfo finalPatternInfo : finalPatternInfos) {
            String prefix = PatternUtil.getBeforeFirstWildcard(finalPatternInfo.finalPattern);
            Pattern pattern = Pattern.compile(finalPatternInfo.finalPattern, 42);
            List<BasicFileInfo> fileInfos = FileScanner.scanTaskInOneCycle(cosClient, bucketName, pattern, prefix, finalPatternInfo.dataTime, cycleUnit);
            infos.addAll(fileInfos);
        }
        return infos;
    }

    public static List<BasicFileInfo> scanTaskInOneCycle(COSClient cosClient, String bucketName, Pattern pattern, String prefix, Long dataTime, String cycleUnit) {
        ObjectListing objectListing;
        ArrayList<BasicFileInfo> infos = new ArrayList<BasicFileInfo>();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
        do {
            try {
                listObjectsRequest.setBucketName(bucketName);
                listObjectsRequest.setPrefix(prefix);
                listObjectsRequest.setDelimiter(DEFAULT_DELIMITER);
                listObjectsRequest.setMaxKeys(Integer.valueOf(100));
                objectListing = cosClient.listObjects(listObjectsRequest);
            }
            catch (CosServiceException e) {
                logger.error("scanTaskInOneCycle finalPattern {} CosServiceException", (Object)pattern.pattern(), (Object)e);
                return infos;
            }
            catch (CosClientException e) {
                logger.error("scanTaskInOneCycle finalPattern {} CosClientException", (Object)pattern.pattern(), (Object)e);
                return infos;
            }
            List commonPrefixes = objectListing.getCommonPrefixes();
            if (!commonPrefixes.isEmpty()) {
                int depth = FileScanner.countCharacterOccurrences((String)commonPrefixes.get(0), '/');
                String nthOccurrenceSubstring = FileScanner.findNthOccurrenceSubstring(pattern.pattern(), '/', depth);
                if (nthOccurrenceSubstring != null) {
                    Pattern patternByDepth = Pattern.compile(nthOccurrenceSubstring, 42);
                    for (String commonPrefix : commonPrefixes) {
                        Matcher matcher = patternByDepth.matcher(commonPrefix);
                        if (!matcher.matches()) continue;
                        infos.addAll(FileScanner.scanTaskInOneCycle(cosClient, bucketName, pattern, commonPrefix, dataTime, cycleUnit));
                    }
                }
            }
            List cosObjectSummaries = objectListing.getObjectSummaries();
            for (COSObjectSummary cosObjectSummary : cosObjectSummaries) {
                String key = cosObjectSummary.getKey();
                Matcher matcher = pattern.matcher(key);
                if (!matcher.lookingAt()) continue;
                long fileSize = cosObjectSummary.getSize();
                String storageClasses = cosObjectSummary.getStorageClass();
                infos.add(new BasicFileInfo(key, DateTransUtils.millSecConvertToTimeStr((long)dataTime, (String)cycleUnit)));
                String strDataTime = DateTransUtils.millSecConvertToTimeStr((long)dataTime, (String)cycleUnit);
                logger.info("list key {} dataTime {} size {}, storageClasses {}", new Object[]{key, strDataTime, fileSize, storageClasses});
            }
            String nextMarker = objectListing.getNextMarker();
            listObjectsRequest.setMarker(nextMarker);
        } while (objectListing.isTruncated());
        return infos;
    }

    public static int countCharacterOccurrences(String input, char targetChar) {
        if (input == null) {
            throw new IllegalArgumentException("Input string cannot be null");
        }
        int count = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != targetChar) continue;
            ++count;
        }
        return count;
    }

    public static String findNthOccurrenceSubstring(String input, char targetChar, int n) {
        int endIndex = FileScanner.findNthOccurrence(input, targetChar, n);
        if (endIndex != -1) {
            return input.substring(0, endIndex + 1);
        }
        return null;
    }

    public static int findNthOccurrence(String input, char targetChar, int n) {
        int currentIndex = -1;
        for (int i = 0; i < n; ++i) {
            if ((currentIndex = input.indexOf(targetChar, currentIndex + 1)) != -1) continue;
            return -1;
        }
        return currentIndex;
    }

    public static class BasicFileInfo {
        public String fileName;
        public String dataTime;

        public BasicFileInfo(String fileName, String dataTime) {
            this.fileName = fileName;
            this.dataTime = dataTime;
        }
    }
}

