/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.datatype;

import com.moilioncircle.redis.replicator.util.Strings;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;

public class Stream
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ID lastId;
    private ID firstId;
    private ID maxDeletedEntryId;
    private Long entriesAdded;
    private NavigableMap<ID, Entry> entries;
    private long length;
    private List<Group> groups;

    public Stream() {
    }

    public Stream(ID lastId, NavigableMap<ID, Entry> entries, long length, List<Group> groups) {
        this.lastId = lastId;
        this.entries = entries;
        this.length = length;
        this.groups = groups;
    }

    public Stream(ID lastId, NavigableMap<ID, Entry> entries, long length, List<Group> groups, ID firstId, ID maxDeletedEntryId, Long entriesAdded) {
        this(lastId, entries, length, groups);
        this.firstId = firstId;
        this.maxDeletedEntryId = maxDeletedEntryId;
        this.entriesAdded = entriesAdded;
    }

    public ID getLastId() {
        return this.lastId;
    }

    public void setLastId(ID lastId) {
        this.lastId = lastId;
    }

    public ID getFirstId() {
        return this.firstId;
    }

    public void setFirstId(ID firstId) {
        this.firstId = firstId;
    }

    public ID getMaxDeletedEntryId() {
        return this.maxDeletedEntryId;
    }

    public void setMaxDeletedEntryId(ID maxDeletedEntryId) {
        this.maxDeletedEntryId = maxDeletedEntryId;
    }

    public Long getEntriesAdded() {
        return this.entriesAdded;
    }

    public void setEntriesAdded(Long entriesAdded) {
        this.entriesAdded = entriesAdded;
    }

    public NavigableMap<ID, Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(NavigableMap<ID, Entry> entries) {
        this.entries = entries;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public String toString() {
        String r = "Stream{lastId=" + this.lastId + ", length=" + this.length;
        r = r + ", firstId=" + this.firstId + ", maxDeletedEntryId=" + this.maxDeletedEntryId + ", entriesAdded=" + this.entriesAdded;
        if (this.groups != null && !this.groups.isEmpty()) {
            r = r + ", groups=" + this.groups;
        }
        if (this.entries != null && !this.entries.isEmpty()) {
            r = r + ", entries=" + this.entries.size();
        }
        return r + '}';
    }

    public static class ID
    implements Serializable,
    Comparable<ID> {
        private static final long serialVersionUID = 1L;
        public static Comparator<ID> COMPARATOR = ID.comparator();
        private long ms;
        private long seq;

        public ID() {
        }

        public ID(long ms, long seq) {
            this.ms = ms;
            this.seq = seq;
        }

        public long getMs() {
            return this.ms;
        }

        public void setMs(long ms) {
            this.ms = ms;
        }

        public long getSeq() {
            return this.seq;
        }

        public void setSeq(long seq) {
            this.seq = seq;
        }

        public ID delta(long ms, long seq) {
            return new ID(this.ms + ms, this.seq + seq);
        }

        public String toString() {
            return this.ms + "-" + this.seq;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ID id = (ID)o;
            return this.ms == id.ms && this.seq == id.seq;
        }

        public int hashCode() {
            return Objects.hash(this.ms, this.seq);
        }

        @Override
        public int compareTo(ID that) {
            int r = Long.compare(this.ms, that.ms);
            if (r == 0) {
                return Long.compare(this.seq, that.seq);
            }
            return r;
        }

        public static ID valueOf(String id) {
            int idx = id.indexOf(45);
            long ms = Long.parseLong(id.substring(0, idx));
            long seq = Long.parseLong(id.substring(idx + 1, id.length()));
            return new ID(ms, seq);
        }

        public static ID valueOf(String strMs, String strSeq) {
            long ms = Long.parseLong(strMs);
            long seq = Long.parseLong(strSeq);
            return new ID(ms, seq);
        }

        public static Comparator<ID> comparator() {
            return new Comparator<ID>(){

                @Override
                public int compare(ID o1, ID o2) {
                    return o1.compareTo(o2);
                }
            };
        }
    }

    public static class Nack
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ID id;
        private Consumer consumer;
        private long deliveryTime;
        private long deliveryCount;

        public Nack() {
        }

        public Nack(ID id, Consumer consumer, long deliveryTime, long deliveryCount) {
            this.id = id;
            this.consumer = consumer;
            this.deliveryTime = deliveryTime;
            this.deliveryCount = deliveryCount;
        }

        public ID getId() {
            return this.id;
        }

        public void setId(ID id) {
            this.id = id;
        }

        public Consumer getConsumer() {
            return this.consumer;
        }

        public void setConsumer(Consumer consumer) {
            this.consumer = consumer;
        }

        public long getDeliveryTime() {
            return this.deliveryTime;
        }

        public void setDeliveryTime(long deliveryTime) {
            this.deliveryTime = deliveryTime;
        }

        public long getDeliveryCount() {
            return this.deliveryCount;
        }

        public void setDeliveryCount(long deliveryCount) {
            this.deliveryCount = deliveryCount;
        }

        public String toString() {
            return "Nack{id=" + this.id + ", consumer=" + this.consumer + ", deliveryTime=" + this.deliveryTime + ", deliveryCount=" + this.deliveryCount + '}';
        }
    }

    public static class Consumer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private byte[] name;
        private long seenTime;
        private NavigableMap<ID, Nack> pendingEntries;

        public Consumer() {
        }

        public Consumer(byte[] name, long seenTime, NavigableMap<ID, Nack> pendingEntries) {
            this.name = name;
            this.seenTime = seenTime;
            this.pendingEntries = pendingEntries;
        }

        public byte[] getName() {
            return this.name;
        }

        public void setName(byte[] name) {
            this.name = name;
        }

        public long getSeenTime() {
            return this.seenTime;
        }

        public void setSeenTime(long seenTime) {
            this.seenTime = seenTime;
        }

        public NavigableMap<ID, Nack> getPendingEntries() {
            return this.pendingEntries;
        }

        public void setPendingEntries(NavigableMap<ID, Nack> pendingEntries) {
            this.pendingEntries = pendingEntries;
        }

        public String toString() {
            String r = "Consumer{name='" + Strings.toString(this.name) + '\'' + ", seenTime=" + this.seenTime;
            if (this.pendingEntries != null && !this.pendingEntries.isEmpty()) {
                r = r + ", cpel=" + this.pendingEntries.size();
            }
            return r + '}';
        }
    }

    public static class Group
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private byte[] name;
        private ID lastId;
        private Long entriesRead;
        private NavigableMap<ID, Nack> pendingEntries;
        private List<Consumer> consumers;

        public Group() {
        }

        public Group(byte[] name, ID lastId, NavigableMap<ID, Nack> pendingEntries, List<Consumer> consumers) {
            this.name = name;
            this.lastId = lastId;
            this.pendingEntries = pendingEntries;
            this.consumers = consumers;
        }

        public Group(byte[] name, ID lastId, NavigableMap<ID, Nack> pendingEntries, List<Consumer> consumers, Long entriesRead) {
            this(name, lastId, pendingEntries, consumers);
            this.entriesRead = entriesRead;
        }

        public byte[] getName() {
            return this.name;
        }

        public void setName(byte[] name) {
            this.name = name;
        }

        public ID getLastId() {
            return this.lastId;
        }

        public void setLastId(ID lastId) {
            this.lastId = lastId;
        }

        public Long getEntriesRead() {
            return this.entriesRead;
        }

        public void setEntriesRead(Long entriesRead) {
            this.entriesRead = entriesRead;
        }

        public NavigableMap<ID, Nack> getPendingEntries() {
            return this.pendingEntries;
        }

        public void setPendingEntries(NavigableMap<ID, Nack> pendingEntries) {
            this.pendingEntries = pendingEntries;
        }

        public List<Consumer> getConsumers() {
            return this.consumers;
        }

        public void setConsumers(List<Consumer> consumers) {
            this.consumers = consumers;
        }

        public String toString() {
            String r = "Group{name='" + Strings.toString(this.name) + '\'' + ", lastId=" + this.lastId + ", entriesRead=" + this.entriesRead;
            if (this.consumers != null && !this.consumers.isEmpty()) {
                r = r + ", consumers=" + this.consumers;
            }
            if (this.pendingEntries != null && !this.pendingEntries.isEmpty()) {
                r = r + ", gpel=" + this.pendingEntries.size();
            }
            return r + '}';
        }
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ID id;
        private boolean deleted;
        private Map<byte[], byte[]> fields;

        public Entry() {
        }

        public Entry(ID id, boolean deleted, Map<byte[], byte[]> fields) {
            this.id = id;
            this.deleted = deleted;
            this.fields = fields;
        }

        public ID getId() {
            return this.id;
        }

        public void setId(ID id) {
            this.id = id;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(boolean deleted) {
            this.deleted = deleted;
        }

        public Map<byte[], byte[]> getFields() {
            return this.fields;
        }

        public void setFields(Map<byte[], byte[]> fields) {
            this.fields = fields;
        }

        public String toString() {
            return "Entry{id=" + this.id + ", deleted=" + this.deleted + ", fields=" + this.fields + '}';
        }
    }
}

