/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.dump;

import com.moilioncircle.redis.replicator.Constants;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.io.ByteBufferOutputStream;
import com.moilioncircle.redis.replicator.io.RawByteListener;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbEncoder;
import com.moilioncircle.redis.replicator.rdb.BaseRdbParser;
import com.moilioncircle.redis.replicator.rdb.DefaultRdbValueVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.dump.datatype.DumpFunction;
import com.moilioncircle.redis.replicator.rdb.module.ModuleParser;
import com.moilioncircle.redis.replicator.rdb.skip.SkipRdbParser;
import com.moilioncircle.redis.replicator.util.ByteArray;
import com.moilioncircle.redis.replicator.util.ByteBuilder;
import com.moilioncircle.redis.replicator.util.CRC64;
import com.moilioncircle.redis.replicator.util.Strings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.NoSuchElementException;

public class DumpRdbValueVisitor
extends DefaultRdbValueVisitor {
    private final int size;
    private final int version;

    public DumpRdbValueVisitor(Replicator replicator) {
        this(replicator, -1);
    }

    public DumpRdbValueVisitor(Replicator replicator, int version) {
        this(replicator, version, 8192);
    }

    public DumpRdbValueVisitor(Replicator replicator, int version, int size) {
        super(replicator);
        this.version = version;
        this.size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyFunction(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(-10, version);
        this.replicator.addRawByteListener(listener);
        try {
            SkipRdbParser parser = new SkipRdbParser(in);
            parser.rdbGenericLoadStringObject();
            parser.rdbGenericLoadStringObject();
            long hasDesc = parser.rdbLoadLen().len;
            if (hasDesc == 1L) {
                parser.rdbGenericLoadStringObject();
            }
            parser.rdbGenericLoadStringObject();
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        DumpFunction function = new DumpFunction();
        function.setSerialized(listener.getBytes());
        return (T)function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyFunction2(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(-11, version);
        this.replicator.addRawByteListener(listener);
        try {
            SkipRdbParser parser = new SkipRdbParser(in);
            parser.rdbGenericLoadStringObject();
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        DumpFunction function = new DumpFunction();
        function.setSerialized(listener.getBytes());
        return (T)function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyString(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(0, version);
        this.replicator.addRawByteListener(listener);
        try {
            new SkipRdbParser(in).rdbLoadEncodedStringObject();
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyList(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(1, version);
        this.replicator.addRawByteListener(listener);
        try {
            SkipRdbParser skipParser = new SkipRdbParser(in);
            for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
                skipParser.rdbLoadEncodedStringObject();
            }
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applySet(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(2, version);
        this.replicator.addRawByteListener(listener);
        try {
            SkipRdbParser skipParser = new SkipRdbParser(in);
            for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
                skipParser.rdbLoadEncodedStringObject();
            }
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyZSet(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(3, version);
        this.replicator.addRawByteListener(listener);
        try {
            SkipRdbParser skipParser = new SkipRdbParser(in);
            for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
                skipParser.rdbLoadEncodedStringObject();
                skipParser.rdbLoadDoubleValue();
            }
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyZSet2(RedisInputStream in, int version) throws IOException {
        if (this.version != -1 && this.version < 8) {
            BaseRdbParser parser = new BaseRdbParser(in);
            BaseRdbEncoder encoder = new BaseRdbEncoder();
            DefaultRawByteListener listener = new DefaultRawByteListener(3, version);
            try (ByteBufferOutputStream out = new ByteBufferOutputStream(this.size);){
                long len;
                listener.handle(encoder.rdbSaveLen(len));
                for (len = parser.rdbLoadLen().len; len > 0L; --len) {
                    ByteArray element = parser.rdbLoadEncodedStringObject();
                    encoder.rdbGenericSaveStringObject(element, out);
                    double score = parser.rdbLoadBinaryDoubleValue();
                    encoder.rdbSaveDoubleValue(score, out);
                }
                listener.handle(out.toByteBuffer());
                byte[] byArray = listener.getBytes();
                return (T)byArray;
            }
        }
        DefaultRawByteListener listener = new DefaultRawByteListener(5, version);
        this.replicator.addRawByteListener(listener);
        try {
            SkipRdbParser skipParser = new SkipRdbParser(in);
            for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
                skipParser.rdbLoadEncodedStringObject();
                skipParser.rdbLoadBinaryDoubleValue();
            }
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyHash(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(4, version);
        this.replicator.addRawByteListener(listener);
        try {
            SkipRdbParser skipParser = new SkipRdbParser(in);
            for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
                skipParser.rdbLoadEncodedStringObject();
                skipParser.rdbLoadEncodedStringObject();
            }
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyHashZipMap(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(9, version);
        this.replicator.addRawByteListener(listener);
        try {
            new SkipRdbParser(in).rdbLoadPlainStringObject();
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyListZipList(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(10, version);
        this.replicator.addRawByteListener(listener);
        try {
            new SkipRdbParser(in).rdbLoadPlainStringObject();
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applySetIntSet(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(11, version);
        this.replicator.addRawByteListener(listener);
        try {
            new SkipRdbParser(in).rdbLoadPlainStringObject();
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyZSetZipList(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(12, version);
        this.replicator.addRawByteListener(listener);
        try {
            new SkipRdbParser(in).rdbLoadPlainStringObject();
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyZSetListPack(RedisInputStream in, int version) throws IOException {
        if (this.version != -1 && this.version < 10) {
            BaseRdbParser parser = new BaseRdbParser(in);
            BaseRdbEncoder encoder = new BaseRdbEncoder();
            DefaultRawByteListener listener = new DefaultRawByteListener(3, version);
            try (ByteBufferOutputStream out = new ByteBufferOutputStream(this.size);){
                int len;
                RedisInputStream listPack = new RedisInputStream(parser.rdbLoadPlainStringObject());
                listPack.skip(4L);
                listener.handle(encoder.rdbSaveLen(len / 2));
                for (len = listPack.readInt(2); len > 0; --len) {
                    byte[] element = BaseRdbParser.StringHelper.listPackEntry(listPack);
                    encoder.rdbGenericSaveStringObject(new ByteArray(element), out);
                    --len;
                    double score = Double.valueOf(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
                    encoder.rdbSaveDoubleValue(score, out);
                }
                int lpend = listPack.read();
                if (lpend != 255) {
                    throw new AssertionError((Object)("listpack expect 255 but " + lpend));
                }
                listener.handle(out.toByteBuffer());
                byte[] byArray = listener.getBytes();
                return (T)byArray;
            }
        }
        DefaultRawByteListener listener = new DefaultRawByteListener(17, version);
        this.replicator.addRawByteListener(listener);
        try {
            SkipRdbParser skipParser = new SkipRdbParser(in);
            skipParser.rdbLoadPlainStringObject();
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyHashZipList(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(13, version);
        this.replicator.addRawByteListener(listener);
        try {
            new SkipRdbParser(in).rdbLoadPlainStringObject();
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyHashListPack(RedisInputStream in, int version) throws IOException {
        if (this.version != -1 && this.version < 10) {
            BaseRdbParser parser = new BaseRdbParser(in);
            BaseRdbEncoder encoder = new BaseRdbEncoder();
            DefaultRawByteListener listener = new DefaultRawByteListener(4, version);
            try (ByteBufferOutputStream out = new ByteBufferOutputStream(this.size);){
                int len;
                RedisInputStream listPack = new RedisInputStream(parser.rdbLoadPlainStringObject());
                listPack.skip(4L);
                listener.handle(encoder.rdbSaveLen(len / 2));
                for (len = listPack.readInt(2); len > 0; --len) {
                    byte[] field = BaseRdbParser.StringHelper.listPackEntry(listPack);
                    encoder.rdbGenericSaveStringObject(new ByteArray(field), out);
                    --len;
                    byte[] value = BaseRdbParser.StringHelper.listPackEntry(listPack);
                    encoder.rdbGenericSaveStringObject(new ByteArray(value), out);
                }
                int lpend = listPack.read();
                if (lpend != 255) {
                    throw new AssertionError((Object)("listpack expect 255 but " + lpend));
                }
                listener.handle(out.toByteBuffer());
                byte[] byArray = listener.getBytes();
                return (T)byArray;
            }
        }
        DefaultRawByteListener listener = new DefaultRawByteListener(16, version);
        this.replicator.addRawByteListener(listener);
        try {
            SkipRdbParser skipParser = new SkipRdbParser(in);
            skipParser.rdbLoadPlainStringObject();
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyListQuickList(RedisInputStream in, int version) throws IOException {
        if (this.version != -1 && this.version < 7) {
            BaseRdbParser parser = new BaseRdbParser(in);
            BaseRdbEncoder encoder = new BaseRdbEncoder();
            try (ByteBufferOutputStream out = new ByteBufferOutputStream(this.size);){
                int total = 0;
                long len = parser.rdbLoadLen().len;
                for (long i = 0L; i < len; ++i) {
                    RedisInputStream stream = new RedisInputStream(parser.rdbGenericLoadStringObject(0));
                    BaseRdbParser.LenHelper.zlbytes(stream);
                    BaseRdbParser.LenHelper.zltail(stream);
                    int zllen = BaseRdbParser.LenHelper.zllen(stream);
                    for (int j = 0; j < zllen; ++j) {
                        byte[] e = BaseRdbParser.StringHelper.zipListEntry(stream);
                        encoder.rdbGenericSaveStringObject(new ByteArray(e), out);
                        ++total;
                    }
                    int zlend = BaseRdbParser.LenHelper.zlend(stream);
                    if (zlend != 255) {
                        throw new AssertionError((Object)("zlend expect 255 but " + zlend));
                    }
                }
                DefaultRawByteListener listener = new DefaultRawByteListener(1, version);
                listener.handle(encoder.rdbSaveLen(total));
                listener.handle(out.toByteBuffer());
                byte[] byArray = listener.getBytes();
                return (T)byArray;
            }
        }
        DefaultRawByteListener listener = new DefaultRawByteListener(14, version);
        this.replicator.addRawByteListener(listener);
        try {
            SkipRdbParser skipParser = new SkipRdbParser(in);
            long len = skipParser.rdbLoadLen().len;
            for (long i = 0L; i < len; ++i) {
                skipParser.rdbGenericLoadStringObject();
            }
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyListQuickList2(RedisInputStream in, int version) throws IOException {
        if (this.version != -1 && this.version < 10) {
            BaseRdbParser parser = new BaseRdbParser(in);
            BaseRdbEncoder encoder = new BaseRdbEncoder();
            try (ByteBufferOutputStream out = new ByteBufferOutputStream(this.size);){
                int total = 0;
                long len = parser.rdbLoadLen().len;
                for (long i = 0L; i < len; ++i) {
                    long container = parser.rdbLoadLen().len;
                    ByteArray bytes = parser.rdbLoadPlainStringObject();
                    if (container == 1L) {
                        encoder.rdbGenericSaveStringObject(new ByteArray(bytes.first()), out);
                        ++total;
                        continue;
                    }
                    if (container == 2L) {
                        RedisInputStream listPack = new RedisInputStream(bytes);
                        listPack.skip(4L);
                        int innerLen = listPack.readInt(2);
                        for (int j = 0; j < innerLen; ++j) {
                            byte[] e = BaseRdbParser.StringHelper.listPackEntry(listPack);
                            encoder.rdbGenericSaveStringObject(new ByteArray(e), out);
                            ++total;
                        }
                        int lpend = listPack.read();
                        if (lpend != 255) {
                            throw new AssertionError((Object)("listpack expect 255 but " + lpend));
                        }
                        continue;
                    }
                    throw new UnsupportedOperationException(String.valueOf(container));
                }
                DefaultRawByteListener listener = new DefaultRawByteListener(1, version);
                listener.handle(encoder.rdbSaveLen(total));
                listener.handle(out.toByteBuffer());
                byte[] byArray = listener.getBytes();
                return (T)byArray;
            }
        }
        DefaultRawByteListener listener = new DefaultRawByteListener(18, version);
        this.replicator.addRawByteListener(listener);
        try {
            SkipRdbParser skipParser = new SkipRdbParser(in);
            long len = skipParser.rdbLoadLen().len;
            for (long i = 0L; i < len; ++i) {
                skipParser.rdbLoadLen();
                skipParser.rdbLoadPlainStringObject();
            }
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyModule(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(6, version);
        this.replicator.addRawByteListener(listener);
        try {
            SkipRdbParser skipParser = new SkipRdbParser(in);
            char[] c = new char[9];
            long moduleid = skipParser.rdbLoadLen().len;
            for (int i = 0; i < c.length; ++i) {
                c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
            }
            String moduleName = new String(c);
            int moduleVersion = (int)(moduleid & 0x3FFL);
            ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
            if (moduleParser == null) {
                throw new NoSuchElementException("module parser[" + moduleName + ", " + moduleVersion + "] not register. rdb type: [RDB_TYPE_MODULE]");
            }
            moduleParser.parse(in, 1);
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyModule2(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(7, version);
        this.replicator.addRawByteListener(listener);
        try {
            BaseRdbParser parser = new BaseRdbParser(in);
            SkipRdbParser skipParser = new SkipRdbParser(in);
            char[] c = new char[9];
            long moduleid = skipParser.rdbLoadLen().len;
            for (int i = 0; i < c.length; ++i) {
                c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
            }
            String moduleName = new String(c);
            int moduleVersion = (int)(moduleid & 0x3FFL);
            ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
            if (moduleParser == null) {
                SkipRdbParser skipRdbParser = new SkipRdbParser(in);
                skipRdbParser.rdbLoadCheckModuleValue();
            } else {
                moduleParser.parse(in, 2);
                long eof = parser.rdbLoadLen().len;
                if (eof != 0L) {
                    throw new UnsupportedOperationException("The RDB file contains module data for the module '" + moduleName + "' that is not terminated by the proper module value EOF marker");
                }
            }
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyStreamListPacks(RedisInputStream in, int version) throws IOException {
        DefaultRawByteListener listener = new DefaultRawByteListener(15, version);
        this.replicator.addRawByteListener(listener);
        try {
            SkipRdbParser skipParser = new SkipRdbParser(in);
            long listPacks = skipParser.rdbLoadLen().len;
            while (listPacks-- > 0L) {
                skipParser.rdbLoadPlainStringObject();
                skipParser.rdbLoadPlainStringObject();
            }
            skipParser.rdbLoadLen();
            skipParser.rdbLoadLen();
            skipParser.rdbLoadLen();
            long groupCount = skipParser.rdbLoadLen().len;
            while (groupCount-- > 0L) {
                skipParser.rdbLoadPlainStringObject();
                skipParser.rdbLoadLen();
                skipParser.rdbLoadLen();
                long groupPel = skipParser.rdbLoadLen().len;
                while (groupPel-- > 0L) {
                    in.skip(16L);
                    skipParser.rdbLoadMillisecondTime();
                    skipParser.rdbLoadLen();
                }
                long consumerCount = skipParser.rdbLoadLen().len;
                while (consumerCount-- > 0L) {
                    skipParser.rdbLoadPlainStringObject();
                    skipParser.rdbLoadMillisecondTime();
                    long consumerPel = skipParser.rdbLoadLen().len;
                    while (consumerPel-- > 0L) {
                        in.skip(16L);
                    }
                }
            }
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T applyStreamListPacks2(RedisInputStream in, int version) throws IOException {
        if (this.version != -1 && this.version < 10) {
            DefaultRawByteListener listener = new DefaultRawByteListener(15, version);
            this.replicator.addRawByteListener(listener);
            try {
                SkipRdbParser skipParser = new SkipRdbParser(in);
                long listPacks = skipParser.rdbLoadLen().len;
                while (listPacks-- > 0L) {
                    skipParser.rdbLoadPlainStringObject();
                    skipParser.rdbLoadPlainStringObject();
                }
                skipParser.rdbLoadLen();
                skipParser.rdbLoadLen();
                skipParser.rdbLoadLen();
                this.replicator.removeRawByteListener(listener);
                skipParser.rdbLoadLen();
                skipParser.rdbLoadLen();
                skipParser.rdbLoadLen();
                skipParser.rdbLoadLen();
                skipParser.rdbLoadLen();
                this.replicator.addRawByteListener(listener);
                long groupCount = skipParser.rdbLoadLen().len;
                while (groupCount-- > 0L) {
                    skipParser.rdbLoadPlainStringObject();
                    skipParser.rdbLoadLen();
                    skipParser.rdbLoadLen();
                    this.replicator.removeRawByteListener(listener);
                    skipParser.rdbLoadLen();
                    this.replicator.addRawByteListener(listener);
                    long groupPel = skipParser.rdbLoadLen().len;
                    while (groupPel-- > 0L) {
                        in.skip(16L);
                        skipParser.rdbLoadMillisecondTime();
                        skipParser.rdbLoadLen();
                    }
                    long consumerCount = skipParser.rdbLoadLen().len;
                    while (consumerCount-- > 0L) {
                        skipParser.rdbLoadPlainStringObject();
                        skipParser.rdbLoadMillisecondTime();
                        long consumerPel = skipParser.rdbLoadLen().len;
                        while (consumerPel-- > 0L) {
                            in.skip(16L);
                        }
                    }
                }
            }
            finally {
                this.replicator.removeRawByteListener(listener);
            }
            return (T)listener.getBytes();
        }
        DefaultRawByteListener listener = new DefaultRawByteListener(19, version);
        this.replicator.addRawByteListener(listener);
        try {
            SkipRdbParser skipParser = new SkipRdbParser(in);
            long listPacks = skipParser.rdbLoadLen().len;
            while (listPacks-- > 0L) {
                skipParser.rdbLoadPlainStringObject();
                skipParser.rdbLoadPlainStringObject();
            }
            skipParser.rdbLoadLen();
            skipParser.rdbLoadLen();
            skipParser.rdbLoadLen();
            skipParser.rdbLoadLen();
            skipParser.rdbLoadLen();
            skipParser.rdbLoadLen();
            skipParser.rdbLoadLen();
            skipParser.rdbLoadLen();
            long groupCount = skipParser.rdbLoadLen().len;
            while (groupCount-- > 0L) {
                skipParser.rdbLoadPlainStringObject();
                skipParser.rdbLoadLen();
                skipParser.rdbLoadLen();
                skipParser.rdbLoadLen();
                long groupPel = skipParser.rdbLoadLen().len;
                while (groupPel-- > 0L) {
                    in.skip(16L);
                    skipParser.rdbLoadMillisecondTime();
                    skipParser.rdbLoadLen();
                }
                long consumerCount = skipParser.rdbLoadLen().len;
                while (consumerCount-- > 0L) {
                    skipParser.rdbLoadPlainStringObject();
                    skipParser.rdbLoadMillisecondTime();
                    long consumerPel = skipParser.rdbLoadLen().len;
                    while (consumerPel-- > 0L) {
                        in.skip(16L);
                    }
                }
            }
        }
        finally {
            this.replicator.removeRawByteListener(listener);
        }
        return (T)listener.getBytes();
    }

    private class DefaultRawByteListener
    implements RawByteListener {
        private final int version;
        private final ByteBuilder builder;

        private DefaultRawByteListener(byte type, int version) {
            this.builder = ByteBuilder.allocate(DumpRdbValueVisitor.this.size);
            this.builder.put(type);
            int ver = DumpRdbValueVisitor.this.version;
            this.version = ver == -1 ? version : ver;
        }

        @Override
        public void handle(byte ... rawBytes) {
            this.builder.put(rawBytes);
        }

        public void handle(ByteBuffer buffer) {
            this.builder.put(buffer);
        }

        public byte[] getBytes() {
            byte[] crc;
            this.builder.put((byte)this.version);
            this.builder.put((byte)0);
            List<ByteBuffer> buffers = this.builder.buffers();
            for (byte b : crc = CRC64.longToByteArray(CRC64.crc64(buffers))) {
                this.builder.put(b);
            }
            return this.builder.array();
        }
    }
}

