/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.util;

import com.moilioncircle.redis.replicator.util.ByteArrayMap;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ByteArrayList
extends AbstractList<byte[]>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final List<ByteArrayMap.Element> list;

    public ByteArrayList() {
        this(16);
    }

    public ByteArrayList(int initialCapacity) {
        this.list = new ArrayList<ByteArrayMap.Element>(initialCapacity);
    }

    public ByteArrayList(Collection<? extends byte[]> c) {
        this(c == null ? 0 : c.size());
        this.addAll(c);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public byte[] get(int index) {
        return this.list.get((int)index).bytes;
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new Iter();
    }

    @Override
    public ListIterator<byte[]> listIterator() {
        return new ListIter();
    }

    @Override
    public byte[] set(int index, byte[] bytes) {
        ByteArrayMap.Element element = this.list.set(index, new ByteArrayMap.Element(bytes));
        return element != null ? element.bytes : null;
    }

    @Override
    public void add(int index, byte[] bytes) {
        this.list.add(index, new ByteArrayMap.Element(bytes));
    }

    @Override
    public byte[] remove(int index) {
        ByteArrayMap.Element element = this.list.remove(index);
        return element != null ? element.bytes : null;
    }

    private final class ListIter
    implements ListIterator<byte[]> {
        private ListIterator<ByteArrayMap.Element> it;

        private ListIter() {
            this.it = ByteArrayList.this.list.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public byte[] next() {
            return this.it.next().bytes;
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public byte[] previous() {
            return this.it.previous().bytes;
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public void set(byte[] bytes) {
            this.it.set(new ByteArrayMap.Element(bytes));
        }

        @Override
        public void add(byte[] bytes) {
            this.it.add(new ByteArrayMap.Element(bytes));
        }
    }

    private final class Iter
    implements Iterator<byte[]> {
        private Iterator<ByteArrayMap.Element> it;

        private Iter() {
            this.it = ByteArrayList.this.list.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public byte[] next() {
            return this.it.next().bytes;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

