/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.plugin;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.DynamicParameter;
import com.github.xiaoymin.knife4j.annotations.DynamicParameters;
import com.github.xiaoymin.knife4j.core.util.CommonUtils;
import com.github.xiaoymin.knife4j.spring.util.ByteUtils;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.schema.property.ModelSpecificationFactory;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ViewProviderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483548)
public class DynamicParameterBuilderPlugin
implements ParameterBuilderPlugin {
    private final SchemaPluginsManager pluginsManager;
    private final TypeResolver typeResolver;
    private final ModelSpecificationFactory models;
    private final Map<String, String> cacheGenModelMaps = new HashMap<String, String>();

    @Autowired
    public DynamicParameterBuilderPlugin(SchemaPluginsManager pluginsManager, TypeResolver typeResolver, ModelSpecificationFactory models) {
        this.pluginsManager = pluginsManager;
        this.typeResolver = typeResolver;
        this.models = models;
    }

    public void apply(ParameterContext parameterContext) {
        ResolvedMethodParameter resolvedMethodParameter = parameterContext.resolvedMethodParameter();
        if (resolvedMethodParameter != null && resolvedMethodParameter.getParameterType() != null && resolvedMethodParameter.getParameterType().getErasedType() != null && (Map.class.isAssignableFrom(resolvedMethodParameter.getParameterType().getErasedType()) || resolvedMethodParameter.getParameterType().getErasedType().getName() == "com.google.gson.JsonObject")) {
            Optional dynamicParametersOptional = parameterContext.getOperationContext().findAnnotation(DynamicParameters.class);
            if (dynamicParametersOptional.isPresent()) {
                this.changeDynamicParameterType((DynamicParameters)dynamicParametersOptional.get(), parameterContext);
            } else {
                Optional supportOptional = parameterContext.getOperationContext().findAnnotation(ApiOperationSupport.class);
                if (supportOptional.isPresent()) {
                    ApiOperationSupport support = (ApiOperationSupport)supportOptional.get();
                    this.changeDynamicParameterType(support.params(), parameterContext);
                }
            }
        }
    }

    private void changeDynamicParameterType(DynamicParameters dynamicParameters, ParameterContext parameterContext) {
        if (dynamicParameters != null) {
            String name = dynamicParameters.name();
            if (name == null || "".equals(name)) {
                name = this.genClassName(parameterContext);
            }
            if (this.cacheGenModelMaps.containsKey(name)) {
                name = this.genClassName(parameterContext);
            }
            name = name.replaceAll("[_-]", "");
            DynamicParameter[] dynamics = dynamicParameters.properties();
            if (dynamics != null && dynamics.length > 0) {
                this.cacheGenModelMaps.put(name, name);
                ResolvedMethodParameter methodParameter = parameterContext.resolvedMethodParameter();
                Class<?> clazzType = ByteUtils.loadDynamicClassType(name);
                if (clazzType != null) {
                    try {
                        ResolvedType parameterType = parameterContext.alternateFor(this.typeResolver.resolve(clazzType, new Type[0]));
                        ModelContext modelContext = this.modelContext(parameterContext, methodParameter, parameterType);
                        ModelSpecification parameterModel = this.models.create(modelContext, parameterType);
                        parameterContext.requestParameterBuilder().contentModel(parameterModel);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private ModelContext modelContext(ParameterContext context, ResolvedMethodParameter methodParameter, ResolvedType parameterType) {
        ViewProviderPlugin viewProvider = this.pluginsManager.viewProvider(context.getDocumentationContext().getDocumentationType());
        return context.getOperationContext().operationModelsBuilder().addInputParam(parameterType, viewProvider.viewFor(methodParameter), new HashSet());
    }

    public String genClassName(ParameterContext parameterContext) {
        String name = parameterContext.getOperationContext().getName();
        return CommonUtils.genSupperName((String)name);
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

