/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class HalFormsOptionsFactory {
    private final Map<Class<?>, Map<String, Function<AffordanceModel.PropertyMetadata, HalFormsOptions>>> options;

    public HalFormsOptionsFactory() {
        this.options = new HashMap();
    }

    private HalFormsOptionsFactory(Map<Class<?>, Map<String, Function<AffordanceModel.PropertyMetadata, HalFormsOptions>>> options) {
        this.options = options;
    }

    HalFormsOptionsFactory withOptions(Class<?> type, String property, Function<AffordanceModel.PropertyMetadata, HalFormsOptions> creator) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.hasText((String)property, (String)"Property must not be null or empty!");
        Assert.notNull(creator, (String)"Creator function must not be null!");
        HashMap options = new HashMap(this.options);
        options.compute(type, (it, map) -> {
            if (map == null) {
                map = new HashMap<String, Function>();
            }
            map.put(property, creator);
            return map;
        });
        return new HalFormsOptionsFactory(options);
    }

    @Nullable
    HalFormsOptions getOptions(AffordanceModel.PayloadMetadata payload, AffordanceModel.PropertyMetadata property) {
        Assert.notNull((Object)payload, (String)"Payload metadata must not be null!");
        Assert.notNull((Object)property, (String)"Property metadata must not be null!");
        Class<?> type = payload.getType();
        String name = property.getName();
        Map<String, Function<AffordanceModel.PropertyMetadata, HalFormsOptions>> map = this.options.get(type);
        if (map == null) {
            return null;
        }
        Function<AffordanceModel.PropertyMetadata, HalFormsOptions> function = map.get(name);
        return function == null ? null : function.apply(property);
    }
}

