/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class Accessors {
    private Accessors() {
    }

    public static Integer toPosition(Accessor<StructLike> accessor) {
        if (accessor instanceof PositionAccessor) {
            return ((PositionAccessor)accessor).position();
        }
        throw new IllegalArgumentException("Cannot convert nested accessor to position");
    }

    static Map<Integer, Accessor<StructLike>> forSchema(Schema schema) {
        return TypeUtil.visit(schema, new BuildPositionAccessors());
    }

    private static Accessor<StructLike> newAccessor(int pos, Type type) {
        return new PositionAccessor(pos, type);
    }

    private static Accessor<StructLike> newAccessor(int pos, boolean isOptional, Accessor<StructLike> accessor) {
        if (isOptional) {
            return new WrappedPositionAccessor(pos, accessor);
        }
        if (accessor.getClass() == PositionAccessor.class) {
            return new Position2Accessor(pos, (PositionAccessor)accessor);
        }
        if (accessor instanceof Position2Accessor) {
            return new Position3Accessor(pos, (Position2Accessor)accessor);
        }
        return new WrappedPositionAccessor(pos, accessor);
    }

    private static class BuildPositionAccessors
    extends TypeUtil.SchemaVisitor<Map<Integer, Accessor<StructLike>>> {
        private BuildPositionAccessors() {
        }

        @Override
        public Map<Integer, Accessor<StructLike>> schema(Schema schema, Map<Integer, Accessor<StructLike>> structResult) {
            return structResult;
        }

        @Override
        public Map<Integer, Accessor<StructLike>> struct(Types.StructType struct, List<Map<Integer, Accessor<StructLike>>> fieldResults) {
            HashMap accessors = Maps.newHashMap();
            List<Types.NestedField> fields = struct.fields();
            for (int i = 0; i < fieldResults.size(); ++i) {
                Types.NestedField field = fields.get(i);
                Map<Integer, Accessor<StructLike>> result = fieldResults.get(i);
                if (result != null) {
                    for (Map.Entry<Integer, Accessor<StructLike>> entry : result.entrySet()) {
                        accessors.put(entry.getKey(), Accessors.newAccessor(i, field.isOptional(), entry.getValue()));
                    }
                }
                accessors.put(field.fieldId(), Accessors.newAccessor(i, field.type()));
            }
            return accessors;
        }

        @Override
        public Map<Integer, Accessor<StructLike>> field(Types.NestedField field, Map<Integer, Accessor<StructLike>> fieldResult) {
            return fieldResult;
        }
    }

    private static class WrappedPositionAccessor
    implements Accessor<StructLike> {
        private final int position;
        private final Accessor<StructLike> accessor;

        WrappedPositionAccessor(int pos, Accessor<StructLike> accessor) {
            this.position = pos;
            this.accessor = accessor;
        }

        @Override
        public Object get(StructLike row) {
            StructLike inner = row.get(this.position, StructLike.class);
            if (inner != null) {
                return this.accessor.get(inner);
            }
            return null;
        }

        @Override
        public Type type() {
            return this.accessor.type();
        }

        public String toString() {
            return "WrappedAccessor(position=" + this.position + ", wrapped=" + this.accessor + ")";
        }
    }

    private static class Position3Accessor
    implements Accessor<StructLike> {
        private final int p0;
        private final int p1;
        private final int p2;
        private final Type type;
        private final Class<?> javaClass;

        Position3Accessor(int pos, Position2Accessor wrapped) {
            this.p0 = pos;
            this.p1 = wrapped.p0;
            this.p2 = wrapped.p1;
            this.type = wrapped.type();
            this.javaClass = wrapped.javaClass();
        }

        @Override
        public Object get(StructLike row) {
            return row.get(this.p0, StructLike.class).get(this.p1, StructLike.class).get(this.p2, this.javaClass);
        }

        @Override
        public Type type() {
            return this.type;
        }

        public String toString() {
            return "Accessor(positions=[" + this.p0 + ", " + this.p1 + ", " + this.p2 + "], type=" + this.type + ")";
        }
    }

    private static class Position2Accessor
    implements Accessor<StructLike> {
        private final int p0;
        private final int p1;
        private final Type type;
        private final Class<?> javaClass;

        Position2Accessor(int pos, PositionAccessor wrapped) {
            this.p0 = pos;
            this.p1 = wrapped.position();
            this.type = wrapped.type();
            this.javaClass = wrapped.javaClass();
        }

        @Override
        public Object get(StructLike row) {
            return row.get(this.p0, StructLike.class).get(this.p1, this.javaClass);
        }

        @Override
        public Type type() {
            return this.type;
        }

        public Class<?> javaClass() {
            return this.javaClass;
        }

        public String toString() {
            return "Accessor(positions=[" + this.p0 + ", " + this.p1 + "], type=" + this.type + ")";
        }
    }

    private static class PositionAccessor
    implements Accessor<StructLike> {
        private final int position;
        private final Type type;
        private final Class<?> javaClass;

        PositionAccessor(int pos, Type type) {
            this.position = pos;
            this.type = type;
            this.javaClass = type.typeId().javaClass();
        }

        @Override
        public Object get(StructLike row) {
            return row.get(this.position, this.javaClass);
        }

        @Override
        public Type type() {
            return this.type;
        }

        public int position() {
            return this.position;
        }

        public Class<?> javaClass() {
            return this.javaClass;
        }

        public String toString() {
            return "Accessor(positions=[" + this.position + "], type=" + this.type + ")";
        }
    }
}

