/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.Immutable;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.relational.Column;
import io.debezium.relational.DefaultValueConverter;
import io.debezium.relational.ValueConverter;
import io.debezium.util.Collect;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class MySqlDefaultValueConverter
implements DefaultValueConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlDefaultValueConverter.class);
    private static final Pattern EPOCH_EQUIVALENT_TIMESTAMP = Pattern.compile("(\\d{4}-\\d{2}-00|\\d{4}-00-\\d{2}|0000-\\d{2}-\\d{2}) (00:00:00(\\.\\d{1,6})?)");
    private static final Pattern EPOCH_EQUIVALENT_DATE = Pattern.compile("\\d{4}-\\d{2}-00|\\d{4}-00-\\d{2}|0000-\\d{2}-\\d{2}");
    private static final String EPOCH_TIMESTAMP = "1970-01-01 00:00:00";
    private static final String EPOCH_DATE = "1970-01-01";
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("([0-9]*-[0-9]*-[0-9]*) ([0-9]*:[0-9]*:[0-9]*(\\.([0-9]*))?)");
    @Immutable
    private static final Set<Integer> TRIM_DATA_TYPES = Collect.unmodifiableSet((Object[])new Integer[]{-6, 4, 91, 93, 2014, 92, 16, -7, 2, 3, 6, 8, 7});
    private static final DateTimeFormatter ISO_LOCAL_DATE_WITH_OPTIONAL_TIME = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(" ").append(DateTimeFormatter.ISO_LOCAL_TIME).optionalEnd().toFormatter();
    private final MySqlValueConverters converters;

    public MySqlDefaultValueConverter(MySqlValueConverters converters) {
        this.converters = converters;
    }

    public Optional<Object> parseDefaultValue(Column column, String defaultValueExpression) {
        Object logicalDefaultValue = this.convert(column, defaultValueExpression);
        if (logicalDefaultValue == null) {
            return Optional.empty();
        }
        SchemaBuilder schemaBuilder = this.converters.schemaBuilder(column);
        if (schemaBuilder == null) {
            return Optional.of(logicalDefaultValue);
        }
        Schema schema = schemaBuilder.build();
        Field field = new Field(column.name(), -1, schema);
        ValueConverter valueConverter = this.converters.converter(column, field);
        return Optional.ofNullable(valueConverter.convert(logicalDefaultValue));
    }

    public Object convert(Column column, String value) {
        if (value == null) {
            return value;
        }
        if (TRIM_DATA_TYPES.contains(column.jdbcType())) {
            value = value.trim();
        }
        if (("TINYINT".equals(column.typeName()) || "INT".equals(column.typeName())) && ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value))) {
            return this.convertToBoolean(value);
        }
        switch (column.jdbcType()) {
            case 91: {
                return this.convertToLocalDate(column, value);
            }
            case 93: {
                return this.convertToLocalDateTime(column, value);
            }
            case 2014: {
                return this.convertToTimestamp(column, value);
            }
            case 92: {
                return this.convertToDuration(column, value);
            }
            case 16: {
                return this.convertToBoolean(value);
            }
            case -7: {
                return this.convertToBits(column, value);
            }
            case 2: 
            case 3: {
                return this.convertToDecimal(column, value);
            }
            case 6: 
            case 7: 
            case 8: {
                return this.convertToDouble(value);
            }
        }
        return value;
    }

    private Object convertToLocalDate(Column column, String value) {
        boolean zero;
        boolean bl = zero = EPOCH_EQUIVALENT_DATE.matcher(value).matches() || EPOCH_EQUIVALENT_TIMESTAMP.matcher(value).matches() || "0".equals(value);
        if (zero && column.isOptional()) {
            return null;
        }
        if (zero) {
            value = EPOCH_DATE;
        }
        try {
            return LocalDate.from(ISO_LOCAL_DATE_WITH_OPTIONAL_TIME.parse(value));
        }
        catch (Exception e) {
            LOGGER.warn("Invalid default value '{}' for date column '{}'; {}", new Object[]{value, column.name(), e.getMessage()});
            if (column.isOptional()) {
                return null;
            }
            return LocalDate.from(ISO_LOCAL_DATE_WITH_OPTIONAL_TIME.parse(EPOCH_DATE));
        }
    }

    private Object convertToLocalDateTime(Column column, String value) {
        boolean matches;
        boolean bl = matches = EPOCH_EQUIVALENT_TIMESTAMP.matcher(value).matches() || "0".equals(value);
        if (matches) {
            if (column.isOptional()) {
                return null;
            }
            value = EPOCH_TIMESTAMP;
        }
        try {
            return LocalDateTime.from(this.timestampFormat(column.length()).parse(value));
        }
        catch (Exception e) {
            LOGGER.warn("Invalid default value '{}' for datetime column '{}'; {}", new Object[]{value, column.name(), e.getMessage()});
            if (column.isOptional()) {
                return null;
            }
            return LocalDateTime.from(this.timestampFormat(column.length()).parse(EPOCH_TIMESTAMP));
        }
    }

    private Object convertToTimestamp(Column column, String value) {
        boolean matches;
        boolean bl = matches = EPOCH_EQUIVALENT_TIMESTAMP.matcher(value).matches() || "0".equals(value) || EPOCH_TIMESTAMP.equals(value);
        if (matches) {
            if (column.isOptional()) {
                return null;
            }
            return Timestamp.from(Instant.EPOCH);
        }
        value = this.cleanTimestamp(value);
        return Timestamp.valueOf(value).toInstant().atZone(ZoneId.systemDefault());
    }

    private Object convertToDuration(Column column, String value) {
        Matcher matcher = TIMESTAMP_PATTERN.matcher(value);
        if (matcher.matches()) {
            value = matcher.group(2);
        }
        return MySqlValueConverters.stringToDuration(value);
    }

    private Object convertToDouble(String value) {
        return Double.parseDouble(value);
    }

    private Object convertToDecimal(Column column, String value) {
        return column.scale().isPresent() ? new BigDecimal(value).setScale((int)((Integer)column.scale().get()), RoundingMode.HALF_UP) : new BigDecimal(value);
    }

    private Object convertToBits(Column column, String value) {
        if (column.length() > 1) {
            return this.convertToBits(value);
        }
        return this.convertToBit(value);
    }

    private Object convertToBit(String value) {
        try {
            return Short.parseShort(value) != 0;
        }
        catch (NumberFormatException ignore) {
            return Boolean.parseBoolean(value);
        }
    }

    private Object convertToBits(String value) {
        int nums = value.length() / 8 + (value.length() % 8 == 0 ? 0 : 1);
        byte[] bytes = new byte[nums];
        for (int i = 0; i < nums; ++i) {
            int s = value.length() - 8 < 0 ? 0 : value.length() - 8;
            int e = value.length();
            bytes[nums - i - 1] = (byte)Integer.parseInt(value.substring(s, e), 2);
            value = value.substring(0, s);
        }
        return bytes;
    }

    private Object convertToBoolean(String value) {
        try {
            return Integer.parseInt(value) != 0;
        }
        catch (NumberFormatException ignore) {
            return Boolean.parseBoolean(value);
        }
    }

    private DateTimeFormatter timestampFormat(int length) {
        DateTimeFormatterBuilder dtf = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").optionalStart().appendLiteral(" ").append(DateTimeFormatter.ISO_LOCAL_TIME).optionalEnd().parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L);
        if (length > 0) {
            dtf.appendFraction(ChronoField.MICRO_OF_SECOND, 0, length, true);
        }
        return dtf.toFormatter();
    }

    private String cleanTimestamp(String s) {
        if (s == null) {
            throw new IllegalArgumentException("null string");
        }
        s = s.trim();
        s = this.replaceFirstNonNumericSubstring(s, 0, '-');
        s = this.replaceFirstNonNumericSubstring(s, s.indexOf(45) + 1, '-');
        if ((s = this.replaceFirstNonNumericSubstring(s, s.indexOf(45, s.indexOf(45) + 1) + 1, ' ')).indexOf(32) != -1 && (s = this.replaceFirstNonNumericSubstring(s, s.indexOf(32) + 1, ':')).indexOf(58) != -1) {
            s = this.replaceFirstNonNumericSubstring(s, s.indexOf(58) + 1, ':');
        }
        int MAX_MONTH = 12;
        int MAX_DAY = 31;
        int firstDash = s.indexOf(45);
        int secondDash = s.indexOf(45, firstDash + 1);
        int dividingSpace = s.indexOf(32);
        int firstColon = s.indexOf(58, dividingSpace + 1);
        int secondColon = s.indexOf(58, firstColon + 1);
        int period = s.indexOf(46, secondColon + 1);
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int len = s.length();
        boolean parsedDate = false;
        if (firstDash > 0 && secondDash > firstDash) {
            year = Integer.parseInt(s.substring(0, firstDash));
            month = Integer.parseInt(s.substring(firstDash + 1, secondDash));
            day = dividingSpace != -1 ? Integer.parseInt(s.substring(secondDash + 1, dividingSpace)) : Integer.parseInt(s.substring(secondDash + 1, len));
            if (month >= 1 && month <= 12 && day >= 1 && day <= 31) {
                parsedDate = true;
            }
        }
        if (!parsedDate) {
            throw new IllegalArgumentException("Cannot parse the date from " + s);
        }
        if (dividingSpace != -1 && dividingSpace < len - 1) {
            if (firstColon == -1) {
                hour = Integer.parseInt(s.substring(dividingSpace + 1, len));
            } else {
                hour = Integer.parseInt(s.substring(dividingSpace + 1, firstColon));
                if (firstColon < len - 1) {
                    if (secondColon == -1) {
                        minute = Integer.parseInt(s.substring(firstColon + 1, len));
                    } else {
                        minute = Integer.parseInt(s.substring(firstColon + 1, secondColon));
                        if (secondColon < len - 1) {
                            second = period == -1 ? Integer.parseInt(s.substring(secondColon + 1, len)) : Integer.parseInt(s.substring(secondColon + 1, period));
                        }
                    }
                }
            }
        }
        StringBuilder cleanedTimestamp = new StringBuilder();
        cleanedTimestamp = cleanedTimestamp.append(String.format("%04d-%02d-%02d %02d:%02d:%02d", year, month, day, hour, minute, second));
        if (period != -1 && period < len - 1) {
            cleanedTimestamp = cleanedTimestamp.append(".").append(s.substring(period + 1));
        }
        return cleanedTimestamp.toString();
    }

    private String replaceFirstNonNumericSubstring(String s, int startIndex, char c) {
        StringBuilder sb = new StringBuilder();
        sb.append(s.substring(0, startIndex));
        String rest = s.substring(startIndex);
        sb.append(rest.replaceFirst("[^\\d]+", Character.toString(c)));
        return sb.toString();
    }
}

