/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.metrics;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flume.Event;
import org.apache.inlong.common.metric.CountMetric;
import org.apache.inlong.common.metric.Dimension;
import org.apache.inlong.common.metric.MetricDomain;
import org.apache.inlong.common.metric.MetricItem;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.metrics.audit.AuditUtils;

@MetricDomain(name="DataProxy")
public class DataProxyMetricItem
extends MetricItem {
    public static final String KEY_CLUSTER_ID = "clusterId";
    public static final String KEY_SOURCE_ID = "sourceId";
    public static final String KEY_SOURCE_DATA_ID = "sourceDataId";
    public static final String KEY_INLONG_GROUP_ID = "inlongGroupId";
    public static final String KEY_INLONG_STREAM_ID = "inlongStreamId";
    public static final String KEY_SINK_ID = "sinkId";
    public static final String KEY_SINK_DATA_ID = "sinkDataId";
    public static final String KEY_MESSAGE_TIME = "msgTime";
    public static final String M_READ_SUCCESS_COUNT = "readSuccessCount";
    public static final String M_READ_SUCCESS_SIZE = "readSuccessSize";
    public static final String M_READ_FAIL_COUNT = "readFailCount";
    public static final String M_READ_FAIL_SIZE = "readFailSize";
    public static final String M_SEND_COUNT = "sendCount";
    public static final String M_SEND_SIZE = "sendSize";
    public static final String M_SEND_SUCCESS_COUNT = "sendSuccessCount";
    public static final String M_SEND_SUCCESS_SIZE = "sendSuccessSize";
    public static final String M_SEND_FAIL_COUNT = "sendFailCount";
    public static final String M_SEND_FAIL_SIZE = "sendFailSize";
    public static final String M_SINK_DURATION = "sinkDuration";
    public static final String M_NODE_DURATION = "nodeDuration";
    public static final String M_WHOLE_DURATION = "wholeDuration";
    public static final String M_READ_PACK_COUNT = "readPackCount";
    public static final String M_READ_PACK_SIZE = "readPackSize";
    public static final String M_SEND_PACK_COUNT = "sendPackCount";
    public static final String M_SEND_PACK_SIZE = "sendPackSize";
    @Dimension
    public String clusterId;
    @Dimension
    public String sourceId;
    @Dimension
    public String sourceDataId;
    @Dimension
    public String inlongGroupId;
    @Dimension
    public String inlongStreamId;
    @Dimension
    public String sinkId;
    @Dimension
    public String sinkDataId;
    @Dimension
    public String msgTime = String.valueOf(0);
    @CountMetric
    public AtomicLong readSuccessCount = new AtomicLong(0L);
    @CountMetric
    public AtomicLong readSuccessSize = new AtomicLong(0L);
    @CountMetric
    public AtomicLong readFailCount = new AtomicLong(0L);
    @CountMetric
    public AtomicLong readFailSize = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sendCount = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sendSize = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sendSuccessCount = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sendSuccessSize = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sendFailCount = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sendFailSize = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sinkDuration = new AtomicLong(0L);
    @CountMetric
    public AtomicLong nodeDuration = new AtomicLong(0L);
    @CountMetric
    public AtomicLong wholeDuration = new AtomicLong(0L);
    @CountMetric
    public AtomicLong readPackCount = new AtomicLong(0L);
    @CountMetric
    public AtomicLong readPackSize = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sendPackCount = new AtomicLong(0L);
    @CountMetric
    public AtomicLong sendPackSize = new AtomicLong(0L);

    public static void fillInlongId(Event event, Map<String, String> dimensions) {
        if (event == null) {
            return;
        }
        Map headers = event.getHeaders();
        String inlongGroupId = DataProxyMetricItem.getInlongGroupId(headers);
        String inlongStreamId = DataProxyMetricItem.getInlongStreamId(headers);
        dimensions.put(KEY_INLONG_GROUP_ID, inlongGroupId);
        dimensions.put(KEY_INLONG_STREAM_ID, inlongStreamId);
    }

    public static void fillAuditFormatTime(Event event, Map<String, String> dimensions) {
        long msgTime = event != null ? AuditUtils.getLogTime(event) : System.currentTimeMillis();
        long auditFormatTime = msgTime - msgTime % CommonConfigHolder.getInstance().getAuditFormatInvlMs();
        dimensions.put(KEY_MESSAGE_TIME, String.valueOf(auditFormatTime));
    }

    public static String getInlongGroupId(Map<String, String> headers) {
        String inlongGroupId = headers.get(KEY_INLONG_GROUP_ID);
        if (inlongGroupId == null) {
            inlongGroupId = headers.getOrDefault("groupId", "");
        }
        return inlongGroupId;
    }

    public static String getInlongStreamId(Map<String, String> headers) {
        String inlongStreamId = headers.get(KEY_INLONG_STREAM_ID);
        if (inlongStreamId == null) {
            inlongStreamId = headers.getOrDefault("streamId", "");
        }
        return inlongStreamId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public long getReadSuccessCount() {
        return this.readSuccessCount.get();
    }

    public long getReadSuccessSize() {
        return this.readSuccessSize.get();
    }

    public long getReadFailCount() {
        return this.readFailCount.get();
    }

    public long getReadFailSize() {
        return this.readFailSize.get();
    }

    public long getSendCount() {
        return this.sendCount.get();
    }

    public long getSendSize() {
        return this.sendSize.get();
    }

    public long getSendSuccessCount() {
        return this.sendSuccessCount.get();
    }

    public long getSendSuccessSize() {
        return this.sendSuccessSize.get();
    }

    public long getSendFailCount() {
        return this.sendFailCount.get();
    }

    public long getSendFailSize() {
        return this.sendFailSize.get();
    }

    public long getSinkAverageDuration() {
        long longSendSuccessCount = this.sendSuccessCount.get();
        if (longSendSuccessCount <= 0L) {
            return 0L;
        }
        return this.sinkDuration.get() / longSendSuccessCount;
    }

    public long getNodeAverageDuration() {
        long longSendSuccessCount = this.sendSuccessCount.get();
        if (longSendSuccessCount <= 0L) {
            return 0L;
        }
        return this.nodeDuration.get() / longSendSuccessCount;
    }

    public long getWholeAverageDuration() {
        long longSendSuccessCount = this.sendSuccessCount.get();
        if (longSendSuccessCount <= 0L) {
            return 0L;
        }
        return this.wholeDuration.get() / longSendSuccessCount;
    }
}

