/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.metrics.stats;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsStatsDaemon
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbsStatsDaemon.class);
    private static final long MAX_PRINT_TIME_MS = 10000L;
    private final String name;
    private final String threadName;
    private final long intervalMs;
    private final int maxStatsCnt;
    private final Thread daemon;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final AtomicInteger writeIndex = new AtomicInteger(0);

    public AbsStatsDaemon(String name, long intervalMs, int maxCnt) {
        this.name = name;
        this.maxStatsCnt = maxCnt;
        this.intervalMs = intervalMs;
        this.threadName = "Daemon_Thread_" + name;
        this.daemon = new Thread((Runnable)this, this.threadName);
        this.daemon.setDaemon(true);
    }

    public void start() {
        this.daemon.start();
        LOGGER.info("{} is started!", (Object)this.name);
    }

    public boolean isStopped() {
        return this.shutdown.get();
    }

    public boolean stop() {
        if (this.shutdown.get()) {
            return true;
        }
        if (this.shutdown.compareAndSet(false, true)) {
            LOGGER.info("{} is closing ......", (Object)this.name);
            try {
                if (this.daemon != null) {
                    this.daemon.interrupt();
                    this.daemon.join();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LOGGER.info("{} is stopped", (Object)this.name);
            return false;
        }
        return true;
    }

    protected abstract int loopProcess(long var1);

    protected abstract int exitProcess(long var1);

    protected int getWriteIndex() {
        return Math.abs(this.writeIndex.get() % 2);
    }

    protected int getReadIndex() {
        return Math.abs((this.writeIndex.get() - 1) % 2);
    }

    @Override
    public void run() {
        int printCnt;
        long startTime;
        LOGGER.info("{} is started", (Object)this.threadName);
        while (!this.shutdown.get()) {
            try {
                Thread.sleep(this.intervalMs);
                this.writeIndex.incrementAndGet();
                startTime = System.currentTimeMillis();
                printCnt = this.loopProcess(startTime);
                this.checkAndPrintStatus(printCnt, System.currentTimeMillis() - startTime);
            }
            catch (InterruptedException e) {
                LOGGER.info("{} has been interrupted", (Object)this.threadName);
                break;
            }
            catch (Throwable t) {
                LOGGER.info("{} throw a exception", (Object)this.threadName);
            }
        }
        startTime = System.currentTimeMillis();
        printCnt = this.exitProcess(startTime);
        this.checkAndPrintStatus(printCnt, System.currentTimeMillis() - startTime);
        LOGGER.info("{} is stopped", (Object)this.threadName);
    }

    private void checkAndPrintStatus(int printCnt, long outputTime) {
        if (printCnt > this.maxStatsCnt) {
            LOGGER.warn("{} print {} items, over max allowed count {}", new Object[]{this.threadName, printCnt, this.maxStatsCnt});
        }
        if (outputTime > 10000L) {
            LOGGER.warn("{} print items wasts {} ms", (Object)this.threadName, (Object)outputTime);
        }
    }
}

