/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.common;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgDedupHandler {
    private static final Logger logger = LoggerFactory.getLogger(MsgDedupHandler.class);
    private static final int DEF_MAX_SURVIVE_CNT_SIZE = 5000000;
    private static final int DEF_MAX_SURVIVE_TIME_MS = 30000;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private volatile boolean enableDataDedup = false;
    private LoadingCache<String, Long> msgSeqIdCache = null;

    public void start(boolean cfgEnableFun, int cfgMaxSurviveTime, int cfgMaxSurviveSize) {
        if (this.started.compareAndSet(false, true)) {
            this.enableDataDedup = cfgEnableFun;
            int maxSurviveTime = cfgMaxSurviveTime;
            int maxSurviveSize = cfgMaxSurviveSize;
            if (this.enableDataDedup) {
                if (maxSurviveTime < 1000) {
                    maxSurviveTime = 30000;
                }
                if (maxSurviveSize < 0) {
                    maxSurviveSize = 5000000;
                }
                this.msgSeqIdCache = CacheBuilder.newBuilder().concurrencyLevel(32).initialCapacity(5000000).expireAfterAccess((long)maxSurviveTime, TimeUnit.MILLISECONDS).maximumSize((long)maxSurviveSize).build((CacheLoader)new CacheLoader<String, Long>(){

                    public Long load(String key) {
                        return System.currentTimeMillis();
                    }
                });
            }
            logger.info("Initial message deduplication handler, enable = " + this.enableDataDedup + ", configured survived-time = " + cfgMaxSurviveTime + ", valid survived-time = " + maxSurviveTime + ", configured survived-size = " + cfgMaxSurviveSize + ", valid survived-size = " + maxSurviveSize);
        }
    }

    public void invalidMsgSeqId(String msgSeqId) {
        if (this.enableDataDedup && msgSeqId != null && this.msgSeqIdCache.asMap().containsKey(msgSeqId)) {
            this.msgSeqIdCache.invalidate((Object)msgSeqId);
        }
    }

    public boolean judgeDupAndPutMsgSeqId(String msgSeqId) {
        boolean isInclude = false;
        if (this.enableDataDedup && msgSeqId != null) {
            isInclude = this.msgSeqIdCache.asMap().containsKey(msgSeqId);
            this.msgSeqIdCache.put((Object)msgSeqId, (Object)System.currentTimeMillis());
        }
        return isInclude;
    }

    public String getCacheStatsInfo() {
        if (this.enableDataDedup) {
            return this.msgSeqIdCache.stats().toString();
        }
        return "Disable for message data deduplication function";
    }

    public CacheStats getCacheData() {
        if (this.enableDataDedup) {
            return this.msgSeqIdCache.stats();
        }
        return null;
    }
}

