/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.util;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.configuration.Configuration;
import org.apache.inlong.common.bounded.Boundaries;
import org.apache.inlong.manager.common.consts.SinkType;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.plugin.flink.FlinkOperation;
import org.apache.inlong.manager.plugin.flink.dto.FlinkConfig;
import org.apache.inlong.manager.plugin.flink.dto.FlinkInfo;
import org.apache.inlong.manager.plugin.flink.enums.Constants;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.stream.InlongStreamExtInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkUtils {
    private static final Logger log = LoggerFactory.getLogger(FlinkUtils.class);
    public static final String BASE_DIRECTORY = "config";
    private static final String DEFAULT_PLUGINS = "plugins";
    private static final String FILE_PREFIX = "file://";
    private static final String DEFAULT_CONFIG_FILE = "flink-sort-plugin.properties";

    public static String getExceptionStackMsg(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return stringWriter.getBuffer().toString();
    }

    public static String findFile(String baseDirName, String pattern) {
        List<String> files = FlinkUtils.listFiles(baseDirName, pattern, 1);
        if (CollectionUtils.isEmpty(files)) {
            return null;
        }
        return files.get(0);
    }

    public static List<String> listFiles(String baseDirName, String pattern, int limit) {
        ArrayList<String> result = new ArrayList<String>();
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            log.error("baseDirName find fail: {}", (Object)baseDirName);
            return result;
        }
        File[] files = baseDir.listFiles();
        if (files == null || files.length == 0) {
            log.info("baseDirName is empty");
            return result;
        }
        File[] fileArray = files;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file;
            File tempFile = file = fileArray[i];
            String tempName = tempFile.getName();
            Pattern jarPathPattern = Pattern.compile(pattern);
            Matcher matcher = jarPathPattern.matcher(tempName);
            boolean matches = matcher.matches();
            if (matches) {
                result.add(tempFile.getAbsoluteFile().toString());
            }
            if (limit <= 0 || result.size() < limit) continue;
            return result;
        }
        return result;
    }

    public static String getConfigDirectory(String name) {
        return BASE_DIRECTORY + File.separator + name;
    }

    public static boolean writeConfigToFile(String configJobDirectory, String configFileName, String content) {
        File file = new File(configJobDirectory);
        if (!file.exists()) {
            file.mkdirs();
        }
        String filePath = configJobDirectory + File.separator + configFileName;
        try {
            FileWriter fileWriter = new FileWriter(filePath);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(content);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException e) {
            log.error("saveConfigToLocal failed", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getFlinkClientService(Configuration configuration, FlinkConfig flinkConfig) {
        log.info("Flink version {}", (Object)flinkConfig.getVersion());
        Path pluginPath = Paths.get(DEFAULT_PLUGINS, new String[0]).toAbsolutePath();
        String flinkJarName = String.format("manager-plugins-flink-v%s.jar", flinkConfig.getVersion());
        String flinkClientPath = FILE_PREFIX + pluginPath + File.separator + flinkJarName;
        log.info("Start to load Flink jar: {}", (Object)flinkClientPath);
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{new URL(flinkClientPath)}, Thread.currentThread().getContextClassLoader());){
            Class<?> flinkClientService = classLoader.loadClass("org.apache.inlong.manager.plugin.flink.FlinkClientService");
            Object flinkService = flinkClientService.getDeclaredConstructor(Configuration.class).newInstance(configuration);
            log.info("Successfully loaded Flink service");
            Object obj = flinkService;
            return obj;
        }
        catch (Exception e) {
            log.error("Failed to loaded Flink service, please check flink client jar path: {}", (Object)flinkClientPath);
            throw new RuntimeException(e);
        }
    }

    public static FlinkConfig getFlinkConfigFromFile() throws Exception {
        Path pluginPath = Paths.get(DEFAULT_PLUGINS, new String[0]).toAbsolutePath();
        String defaultConfigFilePath = pluginPath + File.separator + DEFAULT_CONFIG_FILE;
        log.info("Start to load Flink config from file: {}", (Object)defaultConfigFilePath);
        Properties properties = new Properties();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(defaultConfigFilePath));){
            properties.load(bufferedReader);
        }
        FlinkConfig flinkConfig = new FlinkConfig();
        flinkConfig.setPort(Integer.valueOf(properties.getProperty("flink.rest.port")));
        flinkConfig.setAddress(properties.getProperty("flink.rest.address"));
        flinkConfig.setParallelism(Integer.valueOf(properties.getProperty("flink.parallelism")));
        flinkConfig.setSavepointDirectory(properties.getProperty("flink.savepoint.directory"));
        flinkConfig.setJobManagerPort(Integer.valueOf(properties.getProperty("flink.jobmanager.port")));
        flinkConfig.setDrain(Boolean.parseBoolean(properties.getProperty("flink.drain")));
        flinkConfig.setVersion(properties.getProperty("flink.version"));
        flinkConfig.setDynamicParallelismEnable(Boolean.parseBoolean(properties.getProperty("flink.dynamic.parallelism.enable")));
        flinkConfig.setMaxMsgRatePerCore(Integer.valueOf(properties.getProperty("flink.max.msg.rate.percore")));
        return flinkConfig;
    }

    public static ListenerResult submitFlinkJobs(String groupId, List<InlongStreamInfo> streamInfoList) throws Exception {
        return FlinkUtils.submitFlinkJobs(groupId, streamInfoList, false, null);
    }

    public static ListenerResult submitFlinkJobs(String groupId, List<InlongStreamInfo> streamInfoList, boolean isBatchJob, Boundaries boundaries) throws Exception {
        int sinkCount = streamInfoList.stream().map(s -> s.getSinkList() == null ? 0 : s.getSinkList().size()).reduce(0, Integer::sum);
        if (sinkCount == 0) {
            log.warn("Not any sink configured for group {} and stream list {}, skip launching sort job", (Object)groupId, streamInfoList.stream().map(s -> s.getInlongGroupId() + ":" + s.getName()).collect(Collectors.toList()));
            return ListenerResult.success();
        }
        ArrayList<ListenerResult> listenerResults = new ArrayList<ListenerResult>();
        for (InlongStreamInfo streamInfo : streamInfoList) {
            listenerResults.add(FlinkUtils.submitFlinkJob(streamInfo, FlinkUtils.genFlinkJobName(streamInfo), isBatchJob, boundaries));
        }
        List failedStreams = listenerResults.stream().filter(t -> !t.isSuccess()).collect(Collectors.toList());
        if (failedStreams.isEmpty()) {
            return ListenerResult.success();
        }
        return ListenerResult.fail((String)((ListenerResult)failedStreams.get(0)).getRemark());
    }

    public static ListenerResult submitFlinkJob(InlongStreamInfo streamInfo, String jobName) throws Exception {
        return FlinkUtils.submitFlinkJob(streamInfo, jobName, false, null);
    }

    public static ListenerResult submitFlinkJob(InlongStreamInfo streamInfo, String jobName, boolean isBatchJob, Boundaries boundaries) throws Exception {
        String dataflow;
        List sinkList = streamInfo.getSinkList();
        List sinkTypes = sinkList.stream().map(StreamSink::getSinkType).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)sinkList) || !SinkType.containSortFlinkSink(sinkTypes)) {
            log.warn("not any valid sink configured for groupId {} and streamId {}, reason: {}, skip launching sort job", new Object[]{CollectionUtils.isEmpty((Collection)sinkList) ? "no sink configured" : "no sort flink sink configured", streamInfo.getInlongGroupId(), streamInfo.getInlongStreamId()});
            return ListenerResult.success();
        }
        List extList = streamInfo.getExtList();
        log.info("stream ext info: {}", (Object)extList);
        Map<String, String> kvConf = extList.stream().filter(v -> StringUtils.isNotEmpty((CharSequence)v.getKeyName()) && StringUtils.isNotEmpty((CharSequence)v.getKeyValue())).collect(Collectors.toMap(InlongStreamExtInfo::getKeyName, InlongStreamExtInfo::getKeyValue));
        String sortExtProperties = kvConf.get("sort.properties");
        if (StringUtils.isNotEmpty((CharSequence)sortExtProperties)) {
            Map result = (Map)JsonUtils.OBJECT_MAPPER.convertValue((Object)JsonUtils.OBJECT_MAPPER.readTree(sortExtProperties), (TypeReference)new TypeReference<Map<String, String>>(){});
            kvConf.putAll(result);
        }
        if (StringUtils.isEmpty((CharSequence)(dataflow = kvConf.get("dataflow")))) {
            String message = String.format("dataflow is empty for groupId [%s], streamId [%s]", streamInfo.getInlongGroupId(), streamInfo.getInlongStreamId());
            log.error(message);
            return ListenerResult.fail((String)message);
        }
        FlinkInfo flinkInfo = new FlinkInfo();
        flinkInfo.setJobName(jobName);
        String sortUrl = kvConf.get("sort.url");
        flinkInfo.setEndpoint(sortUrl);
        flinkInfo.setInlongStreamInfoList(Collections.singletonList(streamInfo));
        if (isBatchJob) {
            flinkInfo.setRuntimeExecutionMode("batch");
            flinkInfo.setBoundaryType(boundaries.getBoundaryType().getType());
            flinkInfo.setLowerBoundary(boundaries.getLowerBound());
            flinkInfo.setUpperBoundary(boundaries.getUpperBound());
        } else {
            flinkInfo.setRuntimeExecutionMode("stream");
        }
        FlinkOperation flinkOperation = FlinkOperation.getInstance();
        try {
            flinkOperation.genPath(flinkInfo, dataflow);
            flinkOperation.start(flinkInfo);
            log.info("job submit success for groupId = {}, streamId = {}, jobId = {}", new Object[]{streamInfo.getInlongGroupId(), streamInfo.getInlongStreamId(), flinkInfo.getJobId()});
        }
        catch (Exception e) {
            flinkInfo.setException(true);
            flinkInfo.setExceptionMsg(FlinkUtils.getExceptionStackMsg(e));
            flinkOperation.pollJobStatus(flinkInfo, JobStatus.RUNNING);
            String message = String.format("startup sort failed for groupId [%s], streamId [%s]", streamInfo.getInlongGroupId(), streamInfo.getInlongStreamId());
            log.error(message, (Throwable)e);
            return ListenerResult.fail((String)(message + e.getMessage()));
        }
        FlinkUtils.saveInfo(streamInfo, "sort.job.id", flinkInfo.getJobId(), extList);
        flinkOperation.pollJobStatus(flinkInfo, JobStatus.RUNNING);
        return ListenerResult.success();
    }

    public static void saveInfo(InlongStreamInfo streamInfo, String keyName, String keyValue, List<InlongStreamExtInfo> extInfoList) {
        InlongStreamExtInfo extInfo = new InlongStreamExtInfo();
        extInfo.setInlongGroupId(streamInfo.getInlongGroupId());
        extInfo.setInlongStreamId(streamInfo.getInlongStreamId());
        extInfo.setKeyName(keyName);
        extInfo.setKeyValue(keyValue);
        extInfoList.add(extInfo);
    }

    public static String genFlinkJobName(ProcessForm processForm, InlongStreamInfo streamInfo) {
        return Constants.SORT_JOB_NAME_GENERATOR.apply(processForm) + "-" + streamInfo.getInlongStreamId();
    }

    public static String genFlinkJobName(InlongStreamInfo streamInfo) {
        return String.format("InLong-Sort-%s", streamInfo.getInlongGroupId()) + "-" + streamInfo.getInlongStreamId();
    }
}

