/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over.frame;

import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.operators.over.frame.OverWindowFrame;
import org.apache.flink.table.runtime.operators.over.frame.UnboundedFollowingOverFrame;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.table.types.logical.RowType;

public class RowUnboundedFollowingOverFrame
extends UnboundedFollowingOverFrame {
    private long leftBound;

    public RowUnboundedFollowingOverFrame(RowType valueType, GeneratedAggsHandleFunction aggsHandleFunction, long leftBound) {
        super(valueType, aggsHandleFunction);
        this.leftBound = leftBound;
    }

    @Override
    public RowData process(int index, RowData current) throws Exception {
        boolean bufferUpdated = index == 0;
        ResettableExternalBuffer.BufferIterator iterator = this.input.newIterator(this.inputIndex);
        BinaryRowData nextRow = OverWindowFrame.getNextOrNull(iterator);
        while (nextRow != null && (long)this.inputIndex < (long)index + this.leftBound) {
            ++this.inputIndex;
            bufferUpdated = true;
            nextRow = OverWindowFrame.getNextOrNull(iterator);
        }
        return this.accumulateIterator(bufferUpdated, nextRow, iterator);
    }
}

