/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flume.Context;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.sink.AbstractSinkProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverSinkProcessor
extends AbstractSinkProcessor {
    private static final int FAILURE_PENALTY = 1000;
    private static final int DEFAULT_MAX_PENALTY = 30000;
    private static final Logger logger = LoggerFactory.getLogger(FailoverSinkProcessor.class);
    private static final String PRIORITY_PREFIX = "priority.";
    private static final String MAX_PENALTY_PREFIX = "maxpenalty";
    private Map<String, Sink> sinks;
    private Sink activeSink;
    private SortedMap<Integer, Sink> liveSinks;
    private Queue<FailedSink> failedSinks;
    private int maxPenalty;

    @Override
    public void configure(Context context) {
        this.liveSinks = new TreeMap<Integer, Sink>();
        this.failedSinks = new PriorityQueue<FailedSink>();
        Integer nextPrio = 0;
        String maxPenaltyStr = context.getString(MAX_PENALTY_PREFIX);
        if (maxPenaltyStr == null) {
            this.maxPenalty = 30000;
        } else {
            try {
                this.maxPenalty = Integer.parseInt(maxPenaltyStr);
            }
            catch (NumberFormatException e) {
                logger.warn("{} is not a valid value for {}", new Object[]{maxPenaltyStr, MAX_PENALTY_PREFIX});
                this.maxPenalty = 30000;
            }
        }
        for (Map.Entry<String, Sink> entry : this.sinks.entrySet()) {
            Integer priority;
            String priStr = PRIORITY_PREFIX + entry.getKey();
            try {
                priority = Integer.parseInt(context.getString(priStr));
            }
            catch (Exception e) {
                priority = nextPrio = Integer.valueOf(nextPrio - 1);
            }
            if (!this.liveSinks.containsKey(priority)) {
                this.liveSinks.put(priority, this.sinks.get(entry.getKey()));
                continue;
            }
            logger.warn("Sink {} not added to FailverSinkProcessor as priorityduplicates that of sink {}", (Object)entry.getKey(), this.liveSinks.get(priority));
        }
        this.activeSink = (Sink)this.liveSinks.get(this.liveSinks.lastKey());
    }

    @Override
    public Sink.Status process() throws EventDeliveryException {
        Long now = System.currentTimeMillis();
        while (!this.failedSinks.isEmpty() && this.failedSinks.peek().getRefresh() < now) {
            FailedSink cur = this.failedSinks.poll();
            try {
                Sink.Status s = cur.getSink().process();
                if (s == Sink.Status.READY) {
                    this.liveSinks.put(cur.getPriority(), cur.getSink());
                    this.activeSink = (Sink)this.liveSinks.get(this.liveSinks.lastKey());
                    logger.debug("Sink {} was recovered from the fail list", (Object)cur.getSink().getName());
                } else {
                    this.failedSinks.add(cur);
                }
                return s;
            }
            catch (Exception e) {
                cur.incFails();
                this.failedSinks.add(cur);
            }
        }
        Sink.Status ret = null;
        while (this.activeSink != null) {
            try {
                ret = this.activeSink.process();
                return ret;
            }
            catch (Exception e) {
                logger.warn("Sink {} failed and has been sent to failover list", (Object)this.activeSink.getName(), (Object)e);
                this.activeSink = this.moveActiveToDeadAndGetNext();
            }
        }
        throw new EventDeliveryException("All sinks failed to process, nothing left to failover to");
    }

    private Sink moveActiveToDeadAndGetNext() {
        Integer key = this.liveSinks.lastKey();
        this.failedSinks.add(new FailedSink(key, this.activeSink, 1));
        this.liveSinks.remove(key);
        if (this.liveSinks.isEmpty()) {
            return null;
        }
        if (this.liveSinks.lastKey() != null) {
            return (Sink)this.liveSinks.get(this.liveSinks.lastKey());
        }
        return null;
    }

    @Override
    public void setSinks(List<Sink> sinks) {
        super.setSinks(sinks);
        this.sinks = new HashMap<String, Sink>();
        for (Sink sink : sinks) {
            this.sinks.put(sink.getName(), sink);
        }
    }

    private class FailedSink
    implements Comparable<FailedSink> {
        private Long refresh;
        private Integer priority;
        private Sink sink;
        private Integer sequentialFailures;

        public FailedSink(Integer priority, Sink sink, int seqFailures) {
            this.sink = sink;
            this.priority = priority;
            this.sequentialFailures = seqFailures;
            this.adjustRefresh();
        }

        @Override
        public int compareTo(FailedSink arg0) {
            return this.refresh.compareTo(arg0.refresh);
        }

        public Long getRefresh() {
            return this.refresh;
        }

        public Sink getSink() {
            return this.sink;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void incFails() {
            Integer n = this.sequentialFailures;
            Integer n2 = this.sequentialFailures = Integer.valueOf(this.sequentialFailures + 1);
            this.adjustRefresh();
            logger.debug("Sink {} failed again, new refresh is at {}, current time {}", new Object[]{this.sink.getName(), this.refresh, System.currentTimeMillis()});
        }

        private void adjustRefresh() {
            this.refresh = System.currentTimeMillis() + (long)Math.min(FailoverSinkProcessor.this.maxPenalty, (1 << this.sequentialFailures) * 1000);
        }
    }
}

