/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -4987484334796469814L;
    private final int capacity;
    private final Function<K, V> loader;

    public static <K, V> Map<K, V> create(int cacheSize, Function<K, V> loader) {
        return Collections.synchronizedMap(new LRUCache<K, V>(cacheSize, loader));
    }

    protected LRUCache(int cacheSize, Function<K, V> loader) {
        super(cacheSize, 0.75f, true);
        this.capacity = cacheSize;
        this.loader = Objects.requireNonNull(loader);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.capacity;
    }

    @Override
    public V get(Object key) {
        Object k = Objects.requireNonNull(key);
        Object value = super.get(k);
        if (value == null) {
            value = this.loader.apply(k);
            this.put(k, value);
        }
        return value;
    }
}

