/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.util.Clock;
import java.sql.SQLException;

public class OracleSignalBasedIncrementalSnapshotChangeEventSource
extends SignalBasedIncrementalSnapshotChangeEventSource<TableId> {
    private final String pdbName;
    private final OracleConnection connection;

    public OracleSignalBasedIncrementalSnapshotChangeEventSource(RelationalDatabaseConnectorConfig config, JdbcConnection jdbcConnection, EventDispatcher<TableId> dispatcher, DatabaseSchema<?> databaseSchema, Clock clock, SnapshotProgressListener progressListener, DataChangeEventListener dataChangeEventListener) {
        super(config, jdbcConnection, dispatcher, databaseSchema, clock, progressListener, dataChangeEventListener);
        this.pdbName = ((OracleConnectorConfig)config).getPdbName();
        this.connection = (OracleConnection)jdbcConnection;
    }

    protected String getSignalTableName(String dataCollectionId) {
        TableId tableId = TableId.parse((String)dataCollectionId);
        return tableId.schema() + "." + tableId.table();
    }

    protected void preReadChunk(IncrementalSnapshotContext<TableId> context) {
        super.preReadChunk(context);
        if (this.pdbName != null) {
            this.connection.setSessionToPdb(this.pdbName);
        }
    }

    protected void postReadChunk(IncrementalSnapshotContext<TableId> context) {
        super.postReadChunk(context);
        if (this.pdbName != null) {
            this.connection.resetSessionToCdb();
        }
    }

    protected void postIncrementalSnapshotCompleted() {
        super.postIncrementalSnapshotCompleted();
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new DebeziumException("Failed to close snapshot connection", (Throwable)e);
        }
    }
}

