/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.common;

import java.util.Objects;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.common.ReportProtocol;
import org.apache.inlong.sdk.dataproxy.common.SdkConsts;
import org.apache.inlong.sdk.dataproxy.exception.ProxySdkException;
import org.apache.inlong.sdk.dataproxy.metric.MetricConfig;
import org.apache.inlong.sdk.dataproxy.utils.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyClientConfig
implements Cloneable {
    protected static final Logger logger = LoggerFactory.getLogger(ProxyClientConfig.class);
    private boolean visitMgrByHttps = false;
    private String tlsVersion = "TLSv1.2";
    private String managerIP;
    private int managerPort;
    private boolean enableMgrAuthz = false;
    private String mgrAuthSecretId = "";
    private String mgrAuthSecretKey = "";
    private final String inlongGroupId;
    private final String dataRptProtocol;
    private String regionName = "";
    private String groupMetaConfigKey;
    private int mgrSocketTimeoutMs = 15000;
    private int mgrConnTimeoutMs = 8000;
    private boolean onlyUseLocalProxyConfig = false;
    private long mgrMetaSyncInrMs = 180000L;
    private int metaQueryMaxRetryIfFail = 3;
    private int metaQueryWaitMsIfFail = 500;
    private int metaSyncMaxRetryIfFail = 2;
    private int metaSyncWaitMsIfFail = 800;
    private String metaStoreBasePath = System.getProperty("user.dir");
    private long metaCacheExpiredMs = 1200000L;
    private long metaQryFailCacheExpiredMs = 400L;
    private int aliveConnections = 7;
    private long forceReChooseInrMs = 600000L;
    private int maxInFlightReqCnt = -1;
    private int maxInFlightSizeKb = -1;
    private int paddingSize = 200;
    private final MetricConfig metricConfig = new MetricConfig();
    private boolean enableReportAuthz = false;
    private boolean enableReportEncrypt = false;
    private String rptRsaPubKeyUrl = "";
    private String rptUserName = "";
    private String rptSecretKey = "";

    protected ProxyClientConfig(boolean visitMgrByHttps, String managerIP, int managerPort, String groupId, ReportProtocol rptProtocol, String regionName) throws ProxySdkException {
        this.visitMgrByHttps = visitMgrByHttps;
        if (StringUtils.isBlank(managerIP)) {
            throw new ProxySdkException("managerIP is Blank!");
        }
        this.managerIP = managerIP.trim();
        if (managerPort <= 0) {
            throw new ProxySdkException("managerPort <= 0!");
        }
        this.managerPort = managerPort;
        if (StringUtils.isBlank(groupId)) {
            throw new ProxySdkException("groupId is Blank!");
        }
        this.inlongGroupId = groupId.trim();
        this.dataRptProtocol = rptProtocol.name();
        this.setRegionName(regionName);
        this.groupMetaConfigKey = ProxyUtils.buildGroupIdConfigKey(this.dataRptProtocol, this.regionName, this.inlongGroupId);
    }

    protected ProxyClientConfig(String managerAddress, String groupId, ReportProtocol rptProtocol, String regionName) throws ProxySdkException {
        this.checkAndParseAddress(managerAddress);
        if (StringUtils.isBlank(groupId)) {
            throw new ProxySdkException("groupId is Blank!");
        }
        this.inlongGroupId = groupId.trim();
        this.dataRptProtocol = rptProtocol.name();
        this.setRegionName(regionName);
        this.groupMetaConfigKey = ProxyUtils.buildGroupIdConfigKey(this.dataRptProtocol, this.regionName, this.inlongGroupId);
    }

    public void setMgrAuthzInfo(boolean needMgrAuthz, String mgrAuthSecretId, String mgrAuthSecretKey) throws ProxySdkException {
        this.enableMgrAuthz = needMgrAuthz;
        if (!this.enableMgrAuthz) {
            return;
        }
        if (StringUtils.isBlank(mgrAuthSecretId)) {
            throw new ProxySdkException("mgrAuthSecretId is Blank!");
        }
        if (StringUtils.isBlank(mgrAuthSecretKey)) {
            throw new ProxySdkException("mgrAuthSecretKey is Blank!");
        }
        this.mgrAuthSecretId = mgrAuthSecretId.trim();
        this.mgrAuthSecretKey = mgrAuthSecretKey.trim();
    }

    public void setRptAuthzAndEncryptInfo(Boolean enableRptAuthz, Boolean enableRptEncrypt, String rptUserName, String rptSecretKey, String rptRsaPubKeyUrl) throws ProxySdkException {
        if (enableRptAuthz != null) {
            this.enableReportAuthz = enableRptAuthz;
        }
        if (enableRptEncrypt != null) {
            this.enableReportEncrypt = enableRptEncrypt;
        }
        if (this.enableReportAuthz) {
            if (StringUtils.isBlank(rptUserName)) {
                throw new ProxySdkException("rptUserName is Blank!");
            }
            if (StringUtils.isBlank(rptSecretKey)) {
                throw new ProxySdkException("rptSecretKey is Blank!");
            }
            this.rptUserName = rptUserName.trim();
            this.rptSecretKey = rptSecretKey.trim();
        }
        if (this.enableReportEncrypt) {
            if (StringUtils.isBlank(rptUserName)) {
                throw new ProxySdkException("rptUserName is Blank!");
            }
            if (StringUtils.isBlank(rptRsaPubKeyUrl)) {
                throw new ProxySdkException("rptRsaPubKeyUrl is Blank!");
            }
            this.rptUserName = rptUserName.trim();
            this.rptRsaPubKeyUrl = rptRsaPubKeyUrl.trim();
        }
    }

    public boolean isVisitMgrByHttps() {
        return this.visitMgrByHttps;
    }

    public String getTlsVersion() {
        return this.tlsVersion;
    }

    public void setTlsVersion(String tlsVersion) {
        if (StringUtils.isNotBlank(tlsVersion)) {
            this.tlsVersion = tlsVersion.trim();
        }
    }

    public String getManagerIP() {
        return this.managerIP;
    }

    public int getManagerPort() {
        return this.managerPort;
    }

    public boolean isEnableMgrAuthz() {
        return this.enableMgrAuthz;
    }

    public String getMgrAuthSecretId() {
        return this.mgrAuthSecretId;
    }

    public String getMgrAuthSecretKey() {
        return this.mgrAuthSecretKey;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getDataRptProtocol() {
        return this.dataRptProtocol;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getGroupMetaConfigKey() {
        return this.groupMetaConfigKey;
    }

    public void setRegionName(String regionName) {
        if (StringUtils.isNotBlank(regionName)) {
            this.regionName = regionName.trim().toLowerCase();
            this.groupMetaConfigKey = ProxyUtils.buildGroupIdConfigKey(this.dataRptProtocol, this.regionName, this.inlongGroupId);
        }
    }

    public int getMgrSocketTimeoutMs() {
        return this.mgrSocketTimeoutMs;
    }

    public void setMgrSocketTimeoutMs(int mgrSocketTimeoutMs) {
        this.mgrSocketTimeoutMs = Math.min(60000, Math.max(2000, mgrSocketTimeoutMs));
    }

    public int getMgrConnTimeoutMs() {
        return this.mgrConnTimeoutMs;
    }

    public void setMgrConnTimeoutMs(int mgrConnTimeoutMs) {
        this.mgrConnTimeoutMs = Math.min(60000, Math.max(2000, mgrConnTimeoutMs));
    }

    public boolean isOnlyUseLocalProxyConfig() {
        return this.onlyUseLocalProxyConfig;
    }

    public void setOnlyUseLocalProxyConfig(boolean onlyUseLocalProxyConfig) {
        this.onlyUseLocalProxyConfig = onlyUseLocalProxyConfig;
    }

    public long getMgrMetaSyncInrMs() {
        return this.mgrMetaSyncInrMs;
    }

    public void setMgrMetaSyncInrMin(int mgrMetaSyncInrMin) {
        int tmpValue = Math.min(30, Math.max(1, mgrMetaSyncInrMin));
        this.mgrMetaSyncInrMs = (long)tmpValue * 60000L;
    }

    public int getMetaQueryMaxRetryIfFail() {
        return this.metaQueryMaxRetryIfFail;
    }

    public void setMetaQueryMaxRetryIfFail(int metaQueryMaxRetryIfFail) {
        this.metaQueryMaxRetryIfFail = metaQueryMaxRetryIfFail;
    }

    public int getMetaQueryWaitMsIfFail() {
        return this.metaQueryWaitMsIfFail;
    }

    public void setMetaQueryWaitMsIfFail(int metaQueryWaitMsIfFail) {
        this.metaQueryWaitMsIfFail = Math.min(20000, Math.max(100, metaQueryWaitMsIfFail));
    }

    public int getMetaSyncMaxRetryIfFail() {
        return this.metaSyncMaxRetryIfFail;
    }

    public void setMetaSyncMaxRetryIfFail(int metaSyncMaxRetryIfFail) {
        this.metaSyncMaxRetryIfFail = Math.min(metaSyncMaxRetryIfFail, 5);
    }

    public int getMetaSyncWaitMsIfFail() {
        return this.metaSyncWaitMsIfFail;
    }

    public void setMetaSyncWaitMsIfFail(int metaSyncWaitMsIfFail) {
        this.metaSyncWaitMsIfFail = Math.min(20000, Math.max(100, metaSyncWaitMsIfFail));
    }

    public String getMetaStoreBasePath() {
        return this.metaStoreBasePath;
    }

    public void setMetaStoreBasePath(String metaStoreBasePath) {
        if (StringUtils.isBlank(metaStoreBasePath)) {
            return;
        }
        this.metaStoreBasePath = metaStoreBasePath.trim();
    }

    public long getMetaCacheExpiredMs() {
        return this.metaCacheExpiredMs;
    }

    public void setMetaCacheExpiredMs(long metaCacheExpiredMs) {
        this.metaCacheExpiredMs = metaCacheExpiredMs;
    }

    public long getMetaQryFailCacheExpiredMs() {
        return this.metaQryFailCacheExpiredMs;
    }

    public void setMetaQryFailCacheExpiredMs(long metaQryFailCacheExpiredMs) {
        this.metaQryFailCacheExpiredMs = Math.min(metaQryFailCacheExpiredMs, 180000L);
    }

    public int getAliveConnections() {
        return this.aliveConnections;
    }

    public void setAliveConnections(int aliveConnections) {
        this.aliveConnections = Math.max(1, aliveConnections);
    }

    public long getForceReChooseInrMs() {
        return this.forceReChooseInrMs;
    }

    public void setForceReChooseInrMs(long forceReChooseInrMs) {
        this.forceReChooseInrMs = Math.max(30000L, forceReChooseInrMs);
    }

    public boolean isEnableReportAuthz() {
        return this.enableReportAuthz;
    }

    public boolean isEnableReportEncrypt() {
        return this.enableReportEncrypt;
    }

    public String getRptRsaPubKeyUrl() {
        return this.rptRsaPubKeyUrl;
    }

    public String getRptUserName() {
        return this.rptUserName;
    }

    public String getRptSecretKey() {
        return this.rptSecretKey;
    }

    public boolean isEnableMetric() {
        return this.metricConfig.isEnableMetric();
    }

    public void setEnableMetric(boolean enableMetric) {
        this.metricConfig.setEnableMetric(enableMetric);
    }

    public void setMetricOutIntvlInfo(long metricOutIntvlMs, long metricOutWarnIntMs) {
        this.metricConfig.setMetricOutIntvlInfo(metricOutIntvlMs, metricOutWarnIntMs);
    }

    public void setMetricKeyMaskInfos(boolean maskGroupId, boolean maskStreamId) {
        this.metricConfig.setMetricKeyMaskInfos(maskGroupId, maskStreamId);
    }

    public int getMaxInFlightReqCnt() {
        return this.maxInFlightReqCnt;
    }

    public int getMaxInFlightSizeKb() {
        return this.maxInFlightSizeKb;
    }

    public void setMaxInFlightReqCnt(int maxInFlightReqCnt) {
        if (maxInFlightReqCnt > 0) {
            this.maxInFlightReqCnt = maxInFlightReqCnt;
        }
    }

    public void setMaxInFlightSizeInKb(int maxInFlightSizeInKb) {
        if (maxInFlightSizeInKb > 0) {
            this.maxInFlightSizeKb = maxInFlightSizeInKb;
        }
    }

    public void setMaxInFlightPermitsPerSdk(int maxInFlightReqCnt, int maxInFlightSizeInKb) {
        this.setMaxInFlightReqCnt(maxInFlightReqCnt);
        this.setMaxInFlightSizeInKb(maxInFlightSizeInKb);
    }

    public int getPaddingSize() {
        return this.paddingSize;
    }

    public void setPaddingSize(int paddingSize) {
        this.paddingSize = Math.min(4096, Math.max(0, paddingSize));
    }

    public MetricConfig getMetricConfig() {
        return this.metricConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyClientConfig that = (ProxyClientConfig)o;
        return this.visitMgrByHttps == that.visitMgrByHttps && this.managerPort == that.managerPort && this.enableMgrAuthz == that.enableMgrAuthz && this.mgrSocketTimeoutMs == that.mgrSocketTimeoutMs && this.mgrConnTimeoutMs == that.mgrConnTimeoutMs && this.onlyUseLocalProxyConfig == that.onlyUseLocalProxyConfig && this.mgrMetaSyncInrMs == that.mgrMetaSyncInrMs && this.metaSyncMaxRetryIfFail == that.metaSyncMaxRetryIfFail && this.metaCacheExpiredMs == that.metaCacheExpiredMs && this.metaQryFailCacheExpiredMs == that.metaQryFailCacheExpiredMs && this.aliveConnections == that.aliveConnections && this.forceReChooseInrMs == that.forceReChooseInrMs && this.enableReportAuthz == that.enableReportAuthz && this.maxInFlightReqCnt == that.maxInFlightReqCnt && this.maxInFlightSizeKb == that.maxInFlightSizeKb && this.paddingSize == that.paddingSize && this.enableReportEncrypt == that.enableReportEncrypt && Objects.equals(this.tlsVersion, that.tlsVersion) && Objects.equals(this.managerIP, that.managerIP) && Objects.equals(this.mgrAuthSecretId, that.mgrAuthSecretId) && Objects.equals(this.mgrAuthSecretKey, that.mgrAuthSecretKey) && Objects.equals(this.inlongGroupId, that.inlongGroupId) && Objects.equals(this.dataRptProtocol, that.dataRptProtocol) && Objects.equals(this.regionName, that.regionName) && Objects.equals(this.groupMetaConfigKey, that.groupMetaConfigKey) && Objects.equals(this.metaStoreBasePath, that.metaStoreBasePath) && Objects.equals(this.metricConfig, that.metricConfig) && Objects.equals(this.rptRsaPubKeyUrl, that.rptRsaPubKeyUrl) && Objects.equals(this.rptUserName, that.rptUserName) && Objects.equals(this.rptSecretKey, that.rptSecretKey);
    }

    public int hashCode() {
        return Objects.hash(this.visitMgrByHttps, this.tlsVersion, this.managerIP, this.managerPort, this.enableMgrAuthz, this.mgrAuthSecretId, this.mgrAuthSecretKey, this.inlongGroupId, this.dataRptProtocol, this.regionName, this.groupMetaConfigKey, this.mgrSocketTimeoutMs, this.mgrConnTimeoutMs, this.onlyUseLocalProxyConfig, this.mgrMetaSyncInrMs, this.metaSyncMaxRetryIfFail, this.metaStoreBasePath, this.metaCacheExpiredMs, this.metaQryFailCacheExpiredMs, this.aliveConnections, this.forceReChooseInrMs, this.metricConfig, this.enableReportAuthz, this.enableReportEncrypt, this.rptRsaPubKeyUrl, this.rptUserName, this.rptSecretKey, this.maxInFlightReqCnt, this.maxInFlightSizeKb, this.paddingSize);
    }

    public ProxyClientConfig clone() {
        try {
            return (ProxyClientConfig)super.clone();
        }
        catch (Throwable ex) {
            logger.warn("Failed to clone ManagerConfig", ex);
            return null;
        }
    }

    protected String getSetting(StringBuilder strBuff) {
        strBuff.append(", visitMgrByHttps=").append(this.visitMgrByHttps).append(", tlsVersion='").append(this.tlsVersion).append("', managerIP='").append(this.managerIP).append("', managerPort=").append(this.managerPort).append(", enableMgrAuthz=").append(this.enableMgrAuthz).append(", mgrAuthSecretId='").append(this.mgrAuthSecretId).append("', mgrAuthSecretKey='").append(this.mgrAuthSecretKey).append("', inlongGroupId='").append(this.inlongGroupId).append("', dataRptProtocol='").append(this.dataRptProtocol).append("', regionName='").append(this.regionName).append("', groupMetaConfigKey='").append(this.groupMetaConfigKey).append("', mgrSocketTimeoutMs=").append(this.mgrSocketTimeoutMs).append(", mgrConnTimeoutMs=").append(this.mgrConnTimeoutMs).append(", onlyUseLocalProxyConfig=").append(this.onlyUseLocalProxyConfig).append(", mgrMetaSyncInrMs=").append(this.mgrMetaSyncInrMs).append(", metaSyncMaxRetryIfFail=").append(this.metaSyncMaxRetryIfFail).append(", metaStoreBasePath='").append(this.metaStoreBasePath).append("', metaCacheExpiredMs=").append(this.metaCacheExpiredMs).append(", metaQryFailCacheExpiredMs=").append(this.metaQryFailCacheExpiredMs).append(", aliveConnections=").append(this.aliveConnections).append(", forceReChooseInrMs=").append(this.forceReChooseInrMs).append(", enableReportAuthz=").append(this.enableReportAuthz).append(", enableReportEncrypt=").append(this.enableReportEncrypt).append(", maxInFlightReqCnt=").append(this.maxInFlightReqCnt).append(", maxInFlightSizeKb=").append(this.maxInFlightSizeKb).append(", paddingSize=").append(this.paddingSize).append(", rptRsaPubKeyUrl='").append(this.rptRsaPubKeyUrl).append("', rptUserName='").append(this.rptUserName).append("', rptSecretKey='").append(this.rptSecretKey).append("', metricConfig=");
        this.metricConfig.getSetting(strBuff);
        return strBuff.append("}").toString();
    }

    private void checkAndParseAddress(String managerAddress) throws ProxySdkException {
        int tmValue;
        String hostPortInfo;
        if (StringUtils.isBlank(managerAddress) || !managerAddress.startsWith(SdkConsts.PREFIX_HTTP) && !managerAddress.startsWith(SdkConsts.PREFIX_HTTPS)) {
            throw new ProxySdkException("managerAddress is blank or missing http/https protocol");
        }
        if (managerAddress.startsWith(SdkConsts.PREFIX_HTTPS)) {
            this.visitMgrByHttps = true;
            hostPortInfo = managerAddress.substring(SdkConsts.PREFIX_HTTPS.length());
        } else {
            hostPortInfo = managerAddress.substring(SdkConsts.PREFIX_HTTP.length());
        }
        if (StringUtils.isBlank(hostPortInfo)) {
            throw new ProxySdkException("managerAddress must include host:port info!");
        }
        String[] fields = hostPortInfo.split(":");
        if (fields.length == 1) {
            throw new ProxySdkException("managerAddress must include port info!");
        }
        if (fields.length > 2) {
            throw new ProxySdkException("managerAddress must only include host:port info!");
        }
        if (StringUtils.isBlank(fields[0])) {
            throw new ProxySdkException("managerAddress's host is blank!");
        }
        this.managerIP = fields[0].trim();
        if (StringUtils.isBlank(fields[1])) {
            throw new ProxySdkException("managerAddress's port is blank!");
        }
        try {
            tmValue = Integer.parseInt(fields[1].trim());
        }
        catch (Throwable ex) {
            throw new ProxySdkException("managerAddress's port must be number!");
        }
        if (tmValue <= 0) {
            throw new ProxySdkException("managerAddress's port must be > 0!");
        }
        this.managerPort = tmValue;
    }
}

