/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network.tcp.codec;

import java.util.HashMap;
import java.util.Map;
import org.apache.inlong.common.enums.DataProxyErrCode;
import org.apache.inlong.common.msg.MsgType;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.common.ErrorCode;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;

public class DecodeObject {
    private final MsgType msgType;
    private int messageId;
    private String dpIp;
    private ProcessResult procResult;
    private String addErrMsg;
    private Map<String, String> retAttr;

    public DecodeObject(MsgType msgType, String attributes) {
        this.msgType = msgType;
        this.handleAttr(attributes);
    }

    public DecodeObject(MsgType msgType, int messageId, String attributes) {
        this.msgType = msgType;
        this.messageId = messageId;
        this.handleAttr(attributes);
    }

    public MsgType getMsgType() {
        return this.msgType;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public String getDpIp() {
        return this.dpIp;
    }

    public ProcessResult getSendResult() {
        return this.procResult;
    }

    public String getAddErrMsg() {
        return this.addErrMsg;
    }

    public Map<String, String> getRetAttr() {
        return this.retAttr;
    }

    private void handleAttr(String attributes) {
        String[] keyValSet;
        if (StringUtils.isBlank(attributes)) {
            this.procResult = new ProcessResult(ErrorCode.OK);
            return;
        }
        this.retAttr = new HashMap<String, String>();
        for (String keyVal : keyValSet = attributes.split("&")) {
            if (StringUtils.isBlank(keyVal)) continue;
            String[] keyValSplit = keyVal.split("=");
            if (keyValSplit.length == 1) {
                if (StringUtils.isBlank(keyValSplit[0])) continue;
                this.retAttr.put(keyValSplit[0].trim(), "");
                continue;
            }
            if (StringUtils.isBlank(keyValSplit[0]) || keyValSplit[1] == null) continue;
            this.retAttr.put(keyValSplit[0].trim(), keyValSplit[1].trim());
        }
        if (this.retAttr.containsKey("messageId")) {
            this.messageId = Integer.parseInt(this.retAttr.get("messageId"));
        }
        this.dpIp = this.retAttr.get("dpIP");
        String errCode = this.retAttr.get("errCode");
        if (StringUtils.isBlank(errCode) || Integer.parseInt(errCode) == 0) {
            this.procResult = new ProcessResult(ErrorCode.OK);
        } else {
            this.addErrMsg = this.retAttr.get("errMsg");
            if (StringUtils.isBlank(this.addErrMsg)) {
                this.addErrMsg = DataProxyErrCode.valueOf(Integer.parseInt(errCode)).getErrMsg();
            }
            this.procResult = this.convertToSendResult(Integer.parseInt(errCode));
        }
    }

    private ProcessResult convertToSendResult(int errCode) {
        DataProxyErrCode dpErrCode = DataProxyErrCode.valueOf(errCode);
        switch (dpErrCode) {
            case SINK_SERVICE_UNREADY: {
                return new ProcessResult(ErrorCode.DP_SINK_SERVICE_UNREADY);
            }
            case MISS_REQUIRED_GROUPID_ARGUMENT: 
            case MISS_REQUIRED_STREAMID_ARGUMENT: 
            case MISS_REQUIRED_DT_ARGUMENT: 
            case UNSUPPORTED_EXTEND_FIELD_VALUE: {
                return new ProcessResult(ErrorCode.DP_INVALID_ATTRS, String.valueOf((Object)dpErrCode));
            }
            case MISS_REQUIRED_BODY_ARGUMENT: 
            case EMPTY_MSG: {
                return new ProcessResult(ErrorCode.DP_EMPTY_BODY, String.valueOf((Object)dpErrCode));
            }
            case BODY_EXCEED_MAX_LEN: {
                return new ProcessResult(ErrorCode.DP_BODY_EXCEED_MAX_LEN);
            }
            case UNCONFIGURED_GROUPID_OR_STREAMID: {
                return new ProcessResult(ErrorCode.DP_UNCONFIGURED_GROUPID_OR_STREAMID);
            }
            case PUT_EVENT_TO_CHANNEL_FAILURE: 
            case NO_AVAILABLE_PRODUCER: 
            case PRODUCER_IS_NULL: 
            case SEND_REQUEST_TO_MQ_FAILURE: 
            case MQ_RETURN_ERROR: 
            case DUPLICATED_MESSAGE: {
                return new ProcessResult(ErrorCode.DP_RECEIVE_FAILURE, String.valueOf((Object)dpErrCode));
            }
        }
        return new ProcessResult(ErrorCode.UNKNOWN_ERROR, String.valueOf((Object)dpErrCode));
    }
}

