/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import org.apache.flink.orc.vector.OrcLegacyTimestampColumnVector;
import org.apache.flink.orc.vector.OrcTimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OrcLegacyTimestampColumnVector.class);
    private static Class hiveTSColVectorClz = null;

    private TimestampUtil() {
    }

    public static boolean isHiveTimestampColumnVector(ColumnVector vector) {
        return hiveTSColVectorClz != null && hiveTSColVectorClz.isAssignableFrom(vector.getClass());
    }

    public static ColumnVector createVectorFromConstant(int batchSize, Object value) {
        if (hiveTSColVectorClz != null) {
            return OrcTimestampColumnVector.createFromConstant(batchSize, value);
        }
        return OrcLegacyTimestampColumnVector.createFromConstant(batchSize, value);
    }

    static {
        try {
            hiveTSColVectorClz = Class.forName("org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector");
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Hive TimestampColumnVector not available", e);
        }
    }
}

