/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsgcsv;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.types.Row;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowFormatInfo;
import org.apache.inlong.sort.formats.base.TableFormatConstants;
import org.apache.inlong.sort.formats.base.TextFormatBuilder;
import org.apache.inlong.sort.formats.inlongmsg.FailureHandler;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgBody;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;
import org.apache.inlong.sort.formats.inlongmsg.row.AbstractInLongMsgFormatDeserializer;
import org.apache.inlong.sort.formats.inlongmsg.row.InLongMsgUtils;
import org.apache.inlong.sort.formats.inlongmsgcsv.InLongMsgCsvUtils;

public final class InLongMsgCsvFormatDeserializer
extends AbstractInLongMsgFormatDeserializer {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final RowFormatInfo rowFormatInfo;
    @Nullable
    private final String timeFieldName;
    @Nullable
    private final String attributesFieldName;
    @Nonnull
    private final String charset;
    @Nonnull
    private final Character delimiter;
    @Nullable
    private final Character lineDelimiter;
    @Nullable
    private final Character escapeChar;
    @Nullable
    private final Character quoteChar;
    @Nullable
    private final String nullLiteral;
    private final boolean deleteHeadDelimiter;
    private boolean retainPredefinedField = true;
    private boolean appendEscapeChar = false;

    public InLongMsgCsvFormatDeserializer(@Nonnull RowFormatInfo rowFormatInfo, @Nullable String timeFieldName, @Nullable String attributesFieldName, @Nonnull String charset, @Nonnull Character delimiter, @Nullable Character lineDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral, boolean deleteHeadDelimiter, boolean ignoreErrors, boolean retainPredefinedField) {
        this(rowFormatInfo, timeFieldName, attributesFieldName, charset, delimiter, lineDelimiter, escapeChar, quoteChar, nullLiteral, deleteHeadDelimiter, InLongMsgUtils.getDefaultExceptionHandler(ignoreErrors));
        this.retainPredefinedField = retainPredefinedField;
    }

    public InLongMsgCsvFormatDeserializer(@Nonnull RowFormatInfo rowFormatInfo, @Nullable String timeFieldName, @Nullable String attributesFieldName, @Nonnull String charset, @Nonnull Character delimiter, @Nullable Character lineDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral, boolean deleteHeadDelimiter, boolean ignoreErrors) {
        this(rowFormatInfo, timeFieldName, attributesFieldName, charset, delimiter, lineDelimiter, escapeChar, quoteChar, nullLiteral, deleteHeadDelimiter, InLongMsgUtils.getDefaultExceptionHandler(ignoreErrors));
    }

    public InLongMsgCsvFormatDeserializer(@Nonnull RowFormatInfo rowFormatInfo, @Nullable String timeFieldName, @Nullable String attributesFieldName, @Nonnull String charset, @Nonnull Character delimiter, @Nullable Character lineDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral, boolean deleteHeadDelimiter, @Nonnull FailureHandler failureHandler) {
        super(failureHandler);
        this.rowFormatInfo = rowFormatInfo;
        this.timeFieldName = timeFieldName;
        this.attributesFieldName = attributesFieldName;
        this.delimiter = delimiter;
        this.lineDelimiter = lineDelimiter;
        this.charset = charset;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.nullLiteral = nullLiteral;
        this.deleteHeadDelimiter = deleteHeadDelimiter;
    }

    public TypeInformation<Row> getProducedType() {
        return InLongMsgUtils.decorateRowTypeWithNeededHeadFields(this.timeFieldName, this.attributesFieldName, this.rowFormatInfo);
    }

    @Override
    protected InLongMsgHead parseHead(String attr) {
        return InLongMsgCsvUtils.parseHead(attr);
    }

    @Override
    protected List<InLongMsgBody> parseBodyList(byte[] bytes) {
        return InLongMsgCsvUtils.parseBodyList(bytes, this.charset, this.delimiter.charValue(), this.lineDelimiter, this.escapeChar, this.quoteChar, this.deleteHeadDelimiter);
    }

    @Override
    protected List<Row> convertRows(InLongMsgHead head, InLongMsgBody body) throws Exception {
        Row dataRow = InLongMsgCsvUtils.deserializeRow(this.rowFormatInfo, this.nullLiteral, this.retainPredefinedField ? head.getPredefinedFields() : Collections.emptyList(), body.getFields());
        Row row = InLongMsgUtils.decorateRowWithNeededHeadFields(this.timeFieldName, this.attributesFieldName, head.getTime(), head.getAttributes(), dataRow);
        return Collections.singletonList(row);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InLongMsgCsvFormatDeserializer that = (InLongMsgCsvFormatDeserializer)((Object)o);
        return this.deleteHeadDelimiter == that.deleteHeadDelimiter && this.rowFormatInfo.equals(that.rowFormatInfo) && Objects.equals(this.timeFieldName, that.timeFieldName) && Objects.equals(this.attributesFieldName, that.attributesFieldName) && this.charset.equals(that.charset) && this.delimiter.equals(that.delimiter) && Objects.equals(this.lineDelimiter, that.lineDelimiter) && Objects.equals(this.escapeChar, that.escapeChar) && Objects.equals(this.quoteChar, that.quoteChar) && Objects.equals(this.nullLiteral, that.nullLiteral) && Objects.equals(this.retainPredefinedField, that.retainPredefinedField);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rowFormatInfo, this.timeFieldName, this.attributesFieldName, this.charset, this.delimiter, this.lineDelimiter, this.escapeChar, this.quoteChar, this.nullLiteral, this.deleteHeadDelimiter, this.retainPredefinedField);
    }

    public String toString() {
        return "InLongMsgCsvFormatDeserializer{rowFormatInfo=" + this.rowFormatInfo + ", timeFieldName='" + this.timeFieldName + '\'' + ", attributesFieldName='" + this.attributesFieldName + '\'' + ", charset='" + this.charset + '\'' + ", delimiter=" + this.delimiter + ", lineDelimiter=" + this.lineDelimiter + ", escapeChar=" + this.escapeChar + ", quoteChar=" + this.quoteChar + ", nullLiteral='" + this.nullLiteral + '\'' + ", deleteHeadDelimiter=" + this.deleteHeadDelimiter + ", retainPredefinedField=" + this.retainPredefinedField + '}';
    }

    public static class Builder
    extends TextFormatBuilder<Builder> {
        private String timeFieldName = "inlongmsg_time";
        private String attributesFieldName = "inlongmsg_attributes";
        private Character delimiter = Character.valueOf(',');
        private Character lineDelimiter = TableFormatConstants.DEFAULT_LINE_DELIMITER;
        private Boolean deleteHeadDelimiter = true;
        private Boolean retainPredefinedField = true;
        private Boolean appendEscapeChar = false;

        public Builder(RowFormatInfo rowFormatInfo) {
            super(rowFormatInfo);
        }

        public Builder setTimeFieldName(String timeFieldName) {
            this.timeFieldName = timeFieldName;
            return this;
        }

        public Builder setAttributesFieldName(String attributesFieldName) {
            this.attributesFieldName = attributesFieldName;
            return this;
        }

        public Builder setDelimiter(Character delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder setLineDelimiter(Character lineDelimiter) {
            this.lineDelimiter = lineDelimiter;
            return this;
        }

        public Builder setDeleteHeadDelimiter(Boolean deleteHeadDelimiter) {
            this.deleteHeadDelimiter = deleteHeadDelimiter;
            return this;
        }

        public Builder setRetainPredefinedField(Boolean retainPredefinedField) {
            this.retainPredefinedField = retainPredefinedField;
            return this;
        }

        public Builder setAppendEscapeChar(Boolean appendEscapeChar) {
            this.appendEscapeChar = appendEscapeChar;
            return this;
        }

        @Override
        public Builder configure(DescriptorProperties descriptorProperties) {
            super.configure(descriptorProperties);
            descriptorProperties.getOptionalString("format.time-field-name").ifPresent(this::setTimeFieldName);
            descriptorProperties.getOptionalString("format.attributes-field-name").ifPresent(this::setAttributesFieldName);
            descriptorProperties.getOptionalCharacter("format.delimiter").ifPresent(this::setDelimiter);
            descriptorProperties.getOptionalCharacter("format.line-delimiter").ifPresent(this::setLineDelimiter);
            descriptorProperties.getOptionalBoolean("format.delete-head-delimiter").ifPresent(this::setDeleteHeadDelimiter);
            descriptorProperties.getOptionalBoolean("format.retain-predefined-field").ifPresent(this::setRetainPredefinedField);
            descriptorProperties.getOptionalBoolean("format.append-escape").ifPresent(this::setAppendEscapeChar);
            return this;
        }

        public InLongMsgCsvFormatDeserializer build() {
            return new InLongMsgCsvFormatDeserializer(this.rowFormatInfo, this.timeFieldName, this.attributesFieldName, this.charset, this.delimiter, this.lineDelimiter, this.escapeChar, this.quoteChar, this.nullLiteral, this.deleteHeadDelimiter, this.ignoreErrors, this.retainPredefinedField);
        }
    }
}

