/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.json.debezium;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonRowDataDeserializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.apache.inlong.sort.formats.json.debezium.DebeziumJsonDecodingFormat;
import org.apache.inlong.sort.formats.json.debezium.DebeziumUtils;

@Internal
public final class DebeziumJsonDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final String OP_READ = "r";
    private static final String OP_CREATE = "c";
    private static final String OP_UPDATE = "u";
    private static final String OP_DELETE = "d";
    private static final int BEFORE_POS = 0;
    private static final int AFTER_POS = 1;
    private static final int OP_POS = 2;
    private static final String REPLICA_IDENTITY_EXCEPTION = "The \"before\" field of %s message is null, if you are using Debezium Postgres Connector, please check the Postgres table has been set REPLICA IDENTITY to FULL level.";
    private final JsonRowDataDeserializationSchema jsonDeserializer;
    private final boolean hasMetadata;
    private final MetadataConverter[] metadataConverters;
    private final List<DebeziumJsonDecodingFormat.ReadableMetadata> requestedMetadata;
    private final TypeInformation<RowData> producedTypeInfo;
    private final boolean schemaInclude;
    private final boolean updateBeforeInclude;
    private final boolean ignoreParseErrors;
    private final boolean isMigrateAll;

    public DebeziumJsonDeserializationSchema(DataType physicalDataType, List<DebeziumJsonDecodingFormat.ReadableMetadata> requestedMetadata, TypeInformation<RowData> producedTypeInfo, boolean schemaInclude, boolean updateBeforeInclude, boolean ignoreParseErrors, TimestampFormat timestampFormat, boolean isMigrateAll) {
        this.isMigrateAll = isMigrateAll;
        RowType jsonRowType = DebeziumJsonDeserializationSchema.createJsonRowType(physicalDataType, requestedMetadata, schemaInclude, isMigrateAll);
        this.jsonDeserializer = new JsonRowDataDeserializationSchema(jsonRowType, producedTypeInfo, false, ignoreParseErrors, timestampFormat);
        this.hasMetadata = requestedMetadata.size() > 0;
        this.metadataConverters = DebeziumJsonDeserializationSchema.createMetadataConverters(jsonRowType, requestedMetadata, schemaInclude);
        this.requestedMetadata = requestedMetadata;
        this.producedTypeInfo = producedTypeInfo;
        this.schemaInclude = schemaInclude;
        this.updateBeforeInclude = updateBeforeInclude;
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public RowData deserialize(byte[] message) {
        throw new RuntimeException("Please invoke DeserializationSchema#deserialize(byte[], Collector<RowData>) instead.");
    }

    public void deserialize(byte[] message, Collector<RowData> out) throws IOException {
        block15: {
            if (message == null || message.length == 0) {
                return;
            }
            try {
                GenericRowData after;
                GenericRowData before;
                GenericRowData row = (GenericRowData)this.jsonDeserializer.deserialize(message);
                GenericRowData payload = this.schemaInclude ? (GenericRowData)row.getField(0) : row;
                if (this.isMigrateAll) {
                    before = GenericRowData.of((Object[])new Object[]{payload.getField(0)});
                    after = GenericRowData.of((Object[])new Object[]{payload.getField(1)});
                } else {
                    before = (GenericRowData)payload.getField(0);
                    after = (GenericRowData)payload.getField(1);
                }
                String op = payload.getField(2).toString();
                if (OP_CREATE.equals(op) || OP_READ.equals(op)) {
                    after.setRowKind(RowKind.INSERT);
                    this.emitRow(row, after, out);
                } else if (OP_UPDATE.equals(op)) {
                    if (before == null) {
                        throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "UPDATE"));
                    }
                    before.setRowKind(RowKind.UPDATE_BEFORE);
                    after.setRowKind(RowKind.UPDATE_AFTER);
                    if (this.updateBeforeInclude) {
                        this.emitRow(row, before, out);
                    }
                    this.emitRow(row, after, out);
                } else if (OP_DELETE.equals(op)) {
                    if (before == null) {
                        throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "DELETE"));
                    }
                    before.setRowKind(RowKind.DELETE);
                    this.emitRow(row, before, out);
                } else if (!this.ignoreParseErrors) {
                    throw new IOException(String.format("Unknown \"op\" value \"%s\". The Debezium JSON message is '%s'", op, new String(message)));
                }
            }
            catch (Throwable t2) {
                if (this.ignoreParseErrors) break block15;
                throw new IOException(String.format("Corrupt Debezium JSON message '%s'.", new String(message)), t2);
            }
        }
    }

    private void emitRow(GenericRowData rootRow, GenericRowData physicalRow, Collector<RowData> out) {
        int physicalArity = physicalRow.getArity();
        if (this.isMigrateAll) {
            physicalArity = 0;
        }
        int metadataArity = this.metadataConverters.length;
        GenericRowData producedRow = new GenericRowData(physicalRow.getRowKind(), physicalArity + 1);
        for (int physicalPos = 0; physicalPos < physicalArity; ++physicalPos) {
            producedRow.setField(physicalPos + 1, physicalRow.getField(physicalPos));
        }
        HashMap<StringData, StringData> metadataMap = new HashMap<StringData, StringData>();
        metadataMap.put(StringData.fromString((String)"mysql_metadata_is_ddl"), StringData.fromString((String)"false"));
        for (int metadataPos = 0; metadataPos < metadataArity; ++metadataPos) {
            metadataMap.put(StringData.fromString((String)DebeziumUtils.getMysqlMetadataKey(this.requestedMetadata.get(metadataPos))), StringData.fromString((String)this.metadataConverters[metadataPos].convert(rootRow).toString()));
        }
        if (this.isMigrateAll) {
            metadataMap.put(StringData.fromString((String)"mysql_metadata_data"), (StringData)physicalRow.getField(0));
        }
        producedRow.setField(0, (Object)new GenericMapData(metadataMap));
        out.collect((Object)producedRow);
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebeziumJsonDeserializationSchema that = (DebeziumJsonDeserializationSchema)o;
        return Objects.equals(this.jsonDeserializer, that.jsonDeserializer) && this.hasMetadata == that.hasMetadata && Objects.equals(this.producedTypeInfo, that.producedTypeInfo) && this.schemaInclude == that.schemaInclude && this.ignoreParseErrors == that.ignoreParseErrors;
    }

    public int hashCode() {
        return Objects.hash(this.jsonDeserializer, this.hasMetadata, this.producedTypeInfo, this.schemaInclude, this.ignoreParseErrors);
    }

    private static RowType createJsonRowType(DataType physicalDataType, List<DebeziumJsonDecodingFormat.ReadableMetadata> readableMetadata, boolean schemaInclude, boolean isMigrateAll) {
        DataType dataTypeForDataFields = physicalDataType;
        if (isMigrateAll) {
            dataTypeForDataFields = DataTypes.STRING();
        }
        DataType payload = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"before", (DataType)dataTypeForDataFields), DataTypes.FIELD((String)"after", (DataType)dataTypeForDataFields), DataTypes.FIELD((String)"op", (DataType)DataTypes.STRING())});
        List payloadMetadataFields = readableMetadata.stream().filter(m4 -> m4.isJsonPayload).map(m4 -> m4.requiredJsonField).distinct().collect(Collectors.toList());
        DataType root = payload = DataTypeUtils.appendRowFields((DataType)payload, payloadMetadataFields);
        if (schemaInclude) {
            root = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"payload", (DataType)payload)});
        }
        List rootMetadataFields = readableMetadata.stream().filter(m4 -> !m4.isJsonPayload).map(m4 -> m4.requiredJsonField).distinct().collect(Collectors.toList());
        root = DataTypeUtils.appendRowFields((DataType)root, rootMetadataFields);
        return (RowType)root.getLogicalType();
    }

    private static MetadataConverter[] createMetadataConverters(RowType jsonRowType, List<DebeziumJsonDecodingFormat.ReadableMetadata> requestedMetadata, boolean schemaInclude) {
        return (MetadataConverter[])requestedMetadata.stream().map(m4 -> {
            if (m4.isJsonPayload) {
                return DebeziumJsonDeserializationSchema.convertInPayload(jsonRowType, m4, schemaInclude);
            }
            return DebeziumJsonDeserializationSchema.convertInRoot(jsonRowType, m4);
        }).toArray(MetadataConverter[]::new);
    }

    private static MetadataConverter convertInRoot(RowType jsonRowType, final DebeziumJsonDecodingFormat.ReadableMetadata metadata) {
        final int pos = DebeziumJsonDeserializationSchema.findFieldPos(metadata, jsonRowType);
        return new MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData root, int unused) {
                return metadata.converter.convert(root, pos);
            }
        };
    }

    private static MetadataConverter convertInPayload(RowType jsonRowType, final DebeziumJsonDecodingFormat.ReadableMetadata metadata, boolean schemaInclude) {
        if (schemaInclude) {
            final int pos = DebeziumJsonDeserializationSchema.findFieldPos(metadata, (RowType)jsonRowType.getChildren().get(0));
            return new MetadataConverter(){
                private static final long serialVersionUID = 1L;

                @Override
                public Object convert(GenericRowData root, int unused) {
                    GenericRowData payload = (GenericRowData)root.getField(0);
                    return metadata.converter.convert(payload, pos);
                }
            };
        }
        return DebeziumJsonDeserializationSchema.convertInRoot(jsonRowType, metadata);
    }

    private static int findFieldPos(DebeziumJsonDecodingFormat.ReadableMetadata metadata, RowType jsonRowType) {
        return jsonRowType.getFieldNames().indexOf(metadata.requiredJsonField.getName());
    }

    static interface MetadataConverter
    extends Serializable {
        default public Object convert(GenericRowData row) {
            return this.convert(row, -1);
        }

        public Object convert(GenericRowData var1, int var2);
    }
}

