/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.kv;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowFormatInfo;
import org.apache.inlong.sort.formats.base.DefaultDeserializationSchema;
import org.apache.inlong.sort.formats.base.FieldToRowDataConverters;
import org.apache.inlong.sort.formats.base.FormatMsg;
import org.apache.inlong.sort.formats.base.TableFormatConstants;
import org.apache.inlong.sort.formats.base.TableFormatForRowDataUtils;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.inlongmsg.FailureHandler;
import org.apache.inlong.sort.formats.kv.KvFormatBuilder;
import org.apache.inlong.sort.formats.util.StringUtils;

public class KvRowDataDeserializationSchema
extends DefaultDeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final RowFormatInfo rowFormatInfo;
    @Nonnull
    private final TypeInformation<RowData> producedTypeInfo;
    @Nonnull
    private final String charset;
    @Nonnull
    private final Character entryDelimiter;
    @Nonnull
    private final Character kvDelimiter;
    @Nullable
    private final Character escapeChar;
    @Nullable
    private final Character quoteChar;
    @Nullable
    private final String nullLiteral;
    private final FieldToRowDataConverters.FieldToRowDataConverter[] converters;

    public KvRowDataDeserializationSchema(@Nonnull RowFormatInfo rowFormatInfo, @Nonnull TypeInformation<RowData> producedTypeInfo) {
        this(rowFormatInfo, producedTypeInfo, "UTF-8", Character.valueOf('&'), Character.valueOf('='), TableFormatConstants.DEFAULT_ESCAPE_CHARACTER, TableFormatConstants.DEFAULT_QUOTE_CHARACTER, TableFormatConstants.DEFAULT_NULL_LITERAL);
    }

    public KvRowDataDeserializationSchema(@Nonnull RowFormatInfo rowFormatInfo, @Nonnull TypeInformation<RowData> producedTypeInfo, @Nonnull String charset, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral) {
        this(rowFormatInfo, producedTypeInfo, charset, entryDelimiter, kvDelimiter, escapeChar, quoteChar, nullLiteral, false);
    }

    public KvRowDataDeserializationSchema(@Nonnull RowFormatInfo rowFormatInfo, @Nonnull TypeInformation<RowData> producedTypeInfo, @Nonnull String charset, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral, @Nullable boolean ignoreErrors) {
        super(ignoreErrors);
        this.rowFormatInfo = rowFormatInfo;
        this.producedTypeInfo = producedTypeInfo;
        this.charset = charset;
        this.entryDelimiter = entryDelimiter;
        this.kvDelimiter = kvDelimiter;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.nullLiteral = nullLiteral;
        String[] fieldNames = rowFormatInfo.getFieldNames();
        this.fieldNameSize = fieldNames == null ? 0 : fieldNames.length;
        this.converters = (FieldToRowDataConverters.FieldToRowDataConverter[])Arrays.stream(rowFormatInfo.getFieldFormatInfos()).map(formatInfo -> FieldToRowDataConverters.createConverter(TableFormatForRowDataUtils.deriveLogicalType(formatInfo))).toArray(FieldToRowDataConverters.FieldToRowDataConverter[]::new);
    }

    public KvRowDataDeserializationSchema(@Nonnull RowFormatInfo rowFormatInfo, @Nonnull TypeInformation<RowData> producedTypeInfo, @Nonnull String charset, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral, @Nullable FailureHandler failureHandler) {
        super(failureHandler);
        this.rowFormatInfo = rowFormatInfo;
        this.producedTypeInfo = producedTypeInfo;
        this.charset = charset;
        this.entryDelimiter = entryDelimiter;
        this.kvDelimiter = kvDelimiter;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.nullLiteral = nullLiteral;
        String[] fieldNames = rowFormatInfo.getFieldNames();
        this.fieldNameSize = fieldNames == null ? 0 : fieldNames.length;
        this.converters = (FieldToRowDataConverters.FieldToRowDataConverter[])Arrays.stream(rowFormatInfo.getFieldFormatInfos()).map(formatInfo -> FieldToRowDataConverters.createConverter(TableFormatForRowDataUtils.deriveLogicalType(formatInfo))).toArray(FieldToRowDataConverters.FieldToRowDataConverter[]::new);
    }

    @Override
    public RowData deserializeInternal(byte[] bytes) throws Exception {
        String text = new String(bytes, Charset.forName(this.charset));
        GenericRowData rowData = null;
        try {
            List<Map<String, String>> fieldTexts = StringUtils.splitKv(text, this.entryDelimiter, this.kvDelimiter, this.escapeChar, this.quoteChar, null, true);
            String[] fieldNames = this.rowFormatInfo.getFieldNames();
            FormatInfo[] fieldFormatInfos = this.rowFormatInfo.getFieldFormatInfos();
            rowData = new GenericRowData(fieldFormatInfos.length);
            for (int i = 0; i < fieldFormatInfos.length; ++i) {
                String fieldName = fieldNames[i];
                FormatInfo fieldFormatInfo = fieldFormatInfos[i];
                String fieldText = fieldTexts.get(0).get(fieldName);
                Object field = TableFormatUtils.deserializeBasicField(fieldName, fieldFormatInfo, fieldText, this.nullLiteral, this.failureHandler);
                rowData.setField(i, this.converters[i].convert(field));
            }
            return rowData;
        }
        catch (Throwable t2) {
            this.failureHandler.onParsingMsgFailure(text, new RuntimeException(String.format("Could not properly deserialize kv. Text=[{}].", text), t2));
            return null;
        }
    }

    @Override
    public FormatMsg deserializeFormatMsg(byte[] bytes) throws Exception {
        String text = new String(bytes, Charset.forName(this.charset));
        GenericRowData rowData = null;
        long rowDataLength = 0L;
        try {
            List<Map<String, String>> fieldTexts = StringUtils.splitKv(text, this.entryDelimiter, this.kvDelimiter, this.escapeChar, this.quoteChar, null, true);
            String[] fieldNames = this.rowFormatInfo.getFieldNames();
            FormatInfo[] fieldFormatInfos = this.rowFormatInfo.getFieldFormatInfos();
            rowData = new GenericRowData(fieldFormatInfos.length);
            for (int i = 0; i < fieldFormatInfos.length; ++i) {
                String fieldName = fieldNames[i];
                FormatInfo fieldFormatInfo = fieldFormatInfos[i];
                String fieldText = fieldTexts.get(0).get(fieldName);
                Object field = TableFormatUtils.deserializeBasicField(fieldName, fieldFormatInfo, fieldText, this.nullLiteral, this.failureHandler);
                rowData.setField(i, this.converters[i].convert(field));
                rowDataLength += TableFormatUtils.getFormatValueLength(fieldFormatInfo, fieldText);
            }
            return new FormatMsg((RowData)rowData, rowDataLength);
        }
        catch (Throwable t2) {
            this.failureHandler.onParsingMsgFailure(text, new RuntimeException(String.format("Could not properly deserialize kv. Text=[{}].", text), t2));
            return null;
        }
    }

    public boolean isEndOfStream(RowData rowData) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KvRowDataDeserializationSchema that = (KvRowDataDeserializationSchema)o;
        return this.rowFormatInfo.equals(that.rowFormatInfo) && this.charset.equals(that.charset) && this.entryDelimiter.equals(that.entryDelimiter) && this.kvDelimiter.equals(that.kvDelimiter) && Objects.equals(this.escapeChar, that.escapeChar) && Objects.equals(this.quoteChar, that.quoteChar) && Objects.equals(this.nullLiteral, that.nullLiteral) && Objects.equals(this.failureHandler, that.failureHandler);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rowFormatInfo, this.charset, this.entryDelimiter, this.kvDelimiter, this.escapeChar, this.quoteChar, this.nullLiteral, this.failureHandler);
    }

    public static class Builder
    extends KvFormatBuilder<Builder> {
        private final TypeInformation<RowData> producedTypeInfo;

        public Builder(RowFormatInfo rowFormatInfo, TypeInformation<RowData> producedTypeInfo) {
            super(rowFormatInfo);
            this.producedTypeInfo = producedTypeInfo;
        }

        public KvRowDataDeserializationSchema build() {
            if (this.failureHandler != null) {
                return new KvRowDataDeserializationSchema(this.rowFormatInfo, this.producedTypeInfo, this.charset, Character.valueOf(this.entryDelimiter), Character.valueOf(this.kvDelimiter), this.escapeChar, this.quoteChar, this.nullLiteral, this.failureHandler);
            }
            return new KvRowDataDeserializationSchema(this.rowFormatInfo, this.producedTypeInfo, this.charset, Character.valueOf(this.entryDelimiter), Character.valueOf(this.kvDelimiter), this.escapeChar, this.quoteChar, this.nullLiteral);
        }
    }
}

