/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.function;

import com.google.common.base.Strings;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.sort.function.embedding.EmbeddingInput;
import org.apache.inlong.sort.function.embedding.LanguageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddingFunction
extends ScalarFunction {
    public static final Logger logger = LoggerFactory.getLogger(EmbeddingFunction.class);
    public static final String DEFAULT_EMBEDDING_FUNCTION_NAME = "EMBEDDING";
    private final ObjectMapper mapper = new ObjectMapper();
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    public static final String DEFAULT_MODEL = LanguageModel.BBAI_ZH.getModel();
    private transient HttpClient httpClient;

    public String eval(String url, String input, String model) {
        if (Strings.isNullOrEmpty(url) || Strings.isNullOrEmpty(input)) {
            logger.error("Failed to embedding, both url and input can't be empty or null, url: {}, input: {}", (Object)url, (Object)input);
            return null;
        }
        if (Strings.isNullOrEmpty(model)) {
            model = DEFAULT_MODEL;
            logger.info("model is null, use default model: {}", (Object)model);
        }
        if (!LanguageModel.isLanguageModelSupported(model)) {
            logger.error("Failed to embedding, language model {} not supported(only {} are supported right now)", (Object)model, (Object)LanguageModel.getAllSupportedLanguageModels());
            return null;
        }
        if (this.httpClient == null) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(30000).build();
            this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        }
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            EmbeddingInput embeddingInput = new EmbeddingInput(input, model);
            String encodedContents = this.mapper.writeValueAsString(embeddingInput);
            httpPost.setEntity(new StringEntity(encodedContents));
            HttpResponse response = this.httpClient.execute(httpPost);
            String returnStr = EntityUtils.toString(response.getEntity());
            int returnCode = response.getStatusLine().getStatusCode();
            if (Strings.isNullOrEmpty(returnStr) || 200 != returnCode) {
                throw new Exception("Failed to embedding, result: " + returnStr + ", code: " + returnCode);
            }
            return returnStr;
        }
        catch (Exception e) {
            logger.error("Failed to embedding, url: {}, input: {}", url, input, e);
            return null;
        }
    }
}

