/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.unsafequeues;

import io.moquette.broker.unsafequeues.SegmentPointer;
import io.moquette.broker.unsafequeues.VirtualPointer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Segment {
    private static final Logger LOG = LoggerFactory.getLogger(Segment.class);
    final int segmentSize;
    final SegmentPointer begin;
    final SegmentPointer end;
    private final MappedByteBuffer mappedBuffer;

    Segment(MappedByteBuffer page, SegmentPointer begin, SegmentPointer end) {
        assert (begin.samePage(end));
        this.segmentSize = end.offset() - begin.offset() + 1;
        this.begin = begin;
        this.end = end;
        this.mappedBuffer = page;
    }

    boolean hasSpace(VirtualPointer mark, long length) {
        return this.bytesAfter(mark) >= length;
    }

    public long bytesAfter(SegmentPointer mark) {
        assert (mark.samePage(this.end));
        return this.end.distance(mark);
    }

    public long bytesAfter(VirtualPointer mark) {
        int pageOffset = this.rebasedOffset(mark);
        SegmentPointer physicalMark = new SegmentPointer(this.end.pageId(), (long)pageOffset);
        return this.end.distance(physicalMark);
    }

    void write(SegmentPointer offset, ByteBuffer content) {
        this.checkContentStartWith(content);
        int startPos = offset.offset();
        int endPos = startPos + content.remaining();
        for (int i = startPos; i < endPos; ++i) {
            this.mappedBuffer.put(i, content.get());
        }
    }

    void fillWith(byte value) {
        LOG.debug("Wipe segment {}", (Object)this);
        int target = this.begin.offset() + (int)this.size();
        for (int i = this.begin.offset(); i < target; ++i) {
            this.mappedBuffer.put(i, value);
        }
    }

    private void checkContentStartWith(ByteBuffer content) {
        if (content.get(0) == 0 && content.get(1) == 0 && content.get(2) == 0 && content.get(3) == 0) {
            System.out.println("DNADBG content starts with 4 zero");
        }
    }

    void write(VirtualPointer offset, ByteBuffer content) {
        int startPos = this.rebasedOffset(offset);
        int endPos = startPos + content.remaining();
        for (int i = startPos; i < endPos; ++i) {
            this.mappedBuffer.put(i, content.get());
        }
    }

    void force() {
        this.mappedBuffer.force();
    }

    int readHeader(VirtualPointer pointer) {
        int rebasedIndex = this.rebasedOffset(pointer);
        LOG.debug(" {} {} {} {} at {}", new Object[]{Integer.toHexString(this.mappedBuffer.get(rebasedIndex)), Integer.toHexString(this.mappedBuffer.get(rebasedIndex + 1)), Integer.toHexString(this.mappedBuffer.get(rebasedIndex + 2)), Integer.toHexString(this.mappedBuffer.get(rebasedIndex + 3)), pointer});
        return this.mappedBuffer.getInt(rebasedIndex);
    }

    int rebasedOffset(VirtualPointer virtualPtr) {
        int pointerOffset = (int)virtualPtr.segmentOffset(this.segmentSize);
        return this.begin.plus(pointerOffset).offset();
    }

    public ByteBuffer read(VirtualPointer start, int length) {
        int pageOffset = this.rebasedOffset(start);
        byte[] dst = new byte[length];
        int sourceIdx = pageOffset;
        int dstIndex = 0;
        while (dstIndex < length) {
            dst[dstIndex] = this.mappedBuffer.get(sourceIdx);
            ++dstIndex;
            ++sourceIdx;
        }
        return ByteBuffer.wrap(dst);
    }

    public ByteBuffer read(SegmentPointer start, int length) {
        byte[] dst = new byte[length];
        if (length > this.mappedBuffer.remaining() - start.offset()) {
            throw new BufferUnderflowException();
        }
        int sourceIdx = start.offset();
        int dstIndex = 0;
        while (dstIndex < length) {
            dst[dstIndex] = this.mappedBuffer.get(sourceIdx);
            ++dstIndex;
            ++sourceIdx;
        }
        return ByteBuffer.wrap(dst);
    }

    private long size() {
        return this.end.distance(this.begin) + 1L;
    }

    public String toString() {
        return "Segment{page=" + this.begin.pageId() + ", begin=" + this.begin.offset() + ", end=" + this.end.offset() + ", size=" + this.size() + "}";
    }

    ByteBuffer readAllBytesAfter(SegmentPointer start) {
        long availableDataLength = this.bytesAfter(start) + 1L;
        ByteBuffer buffer = this.read(start, (int)availableDataLength);
        buffer.rewind();
        return buffer;
    }

    ByteBuffer readAllBytesAfter(VirtualPointer start) {
        long availableDataLength = this.bytesAfter(start) + 1L;
        ByteBuffer buffer = this.read(start, (int)availableDataLength);
        buffer.rewind();
        return buffer;
    }
}

