/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import org.apache.tsfile.encoding.encoder.GorillaEncoderV1;

public class DoublePrecisionEncoderV1
extends GorillaEncoderV1 {
    private long preValue;

    @Override
    public void encode(double value, ByteArrayOutputStream out) {
        if (!this.flag) {
            this.flag = true;
            this.preValue = Double.doubleToLongBits(value);
            this.leadingZeroNum = Long.numberOfLeadingZeros(this.preValue);
            this.tailingZeroNum = Long.numberOfTrailingZeros(this.preValue);
            byte[] bufferLittle = new byte[8];
            for (int i = 0; i < 8; ++i) {
                bufferLittle[i] = (byte)(this.preValue >> i * 8 & 0xFFL);
            }
            out.write(bufferLittle, 0, bufferLittle.length);
        } else {
            long nextValue = Double.doubleToLongBits(value);
            long tmp = nextValue ^ this.preValue;
            if (tmp == 0L) {
                this.writeBit(false, out);
            } else {
                int leadingZeroNumTmp = Long.numberOfLeadingZeros(tmp);
                int tailingZeroNumTmp = Long.numberOfTrailingZeros(tmp);
                if (leadingZeroNumTmp >= this.leadingZeroNum && tailingZeroNumTmp >= this.tailingZeroNum) {
                    this.writeBit(true, out);
                    this.writeBit(false, out);
                    this.writeBits(tmp, out, 63 - this.leadingZeroNum, this.tailingZeroNum);
                } else {
                    this.writeBit(true, out);
                    this.writeBit(true, out);
                    this.writeBits(leadingZeroNumTmp, out, 5, 0);
                    this.writeBits(64L - (long)leadingZeroNumTmp - (long)tailingZeroNumTmp, out, 6, 0);
                    this.writeBits(tmp, out, 63 - leadingZeroNumTmp, tailingZeroNumTmp);
                }
            }
            this.preValue = nextValue;
            this.leadingZeroNum = Long.numberOfLeadingZeros(this.preValue);
            this.tailingZeroNum = Long.numberOfTrailingZeros(this.preValue);
        }
    }

    private void writeBits(long num, ByteArrayOutputStream out, int start, int end) {
        for (int i = start; i >= end; --i) {
            long bit = num & 1L << i;
            this.writeBit(bit, out);
        }
    }

    @Override
    public void flush(ByteArrayOutputStream out) {
        this.encode(Double.NaN, out);
        this.clearBuffer(out);
        this.reset();
    }

    @Override
    public int getOneItemMaxSize() {
        return 10;
    }

    @Override
    public long getMaxByteSize() {
        return 20L;
    }
}

