/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.aggregate.operator.intermediateresult.sametype.numeric;

import org.apache.iotdb.db.pipe.processor.aggregate.operator.intermediateresult.sametype.numeric.AbstractSameTypeNumericOperator;

public class IntegralPoweredSumOperator
extends AbstractSameTypeNumericOperator {
    private final transient int power;

    public IntegralPoweredSumOperator(int power) {
        this.power = power;
    }

    @Override
    public String getName() {
        return "sum_x" + this.power;
    }

    @Override
    public boolean initAndGetIsSupport(int initialInput, long initialTimestamp) {
        this.intValue = (int)Math.pow(initialInput, this.power);
        return super.initAndGetIsSupport(initialInput, initialTimestamp);
    }

    @Override
    public boolean initAndGetIsSupport(long initialInput, long initialTimestamp) {
        this.longValue = (long)Math.pow(initialInput, this.power);
        return super.initAndGetIsSupport(initialInput, initialTimestamp);
    }

    @Override
    public boolean initAndGetIsSupport(float initialInput, long initialTimestamp) {
        this.floatValue = (float)Math.pow(initialInput, this.power);
        return super.initAndGetIsSupport(initialInput, initialTimestamp);
    }

    @Override
    public boolean initAndGetIsSupport(double initialInput, long initialTimestamp) {
        this.doubleValue = Math.pow(initialInput, this.power);
        return super.initAndGetIsSupport(initialInput, initialTimestamp);
    }

    @Override
    public void updateValue(int input, long timestamp) {
        this.intValue += (int)Math.pow(input, this.power);
    }

    @Override
    public void updateValue(long input, long timestamp) {
        this.longValue += (long)Math.pow(input, this.power);
    }

    @Override
    public void updateValue(float input, long timestamp) {
        this.floatValue += (float)Math.pow(input, this.power);
    }

    @Override
    public void updateValue(double input, long timestamp) {
        this.doubleValue += Math.pow(input, this.power);
    }
}

