/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.active;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.WrappedRunnable;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActiveLoadScheduledExecutorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveLoadScheduledExecutorService.class);
    protected static final IoTDBConfig IOTDB_CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final long MIN_EXECUTION_INTERVAL_SECONDS = IOTDB_CONFIG.getLoadActiveListeningCheckIntervalSeconds();
    private final ScheduledExecutorService scheduledExecutorService;
    private Future<?> future;
    private final List<Pair<WrappedRunnable, Long>> jobs = new CopyOnWriteArrayList<Pair<WrappedRunnable, Long>>();

    protected ActiveLoadScheduledExecutorService(ThreadName threadName) {
        this.scheduledExecutorService = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)threadName.name());
    }

    public void register(final Runnable runnable) {
        this.jobs.add((Pair<WrappedRunnable, Long>)new Pair((Object)new WrappedRunnable(){

            public void runMayThrow() {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    LOGGER.warn("Error occurred when executing active load periodical job.", (Throwable)e);
                }
            }
        }, (Object)Math.max(MIN_EXECUTION_INTERVAL_SECONDS, 1L)));
    }

    public synchronized void start() {
        if (this.future == null) {
            this.future = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.scheduledExecutorService, this::execute, (long)MIN_EXECUTION_INTERVAL_SECONDS, (long)MIN_EXECUTION_INTERVAL_SECONDS, (TimeUnit)TimeUnit.SECONDS);
            LOGGER.info("Active load periodical jobs executor is started successfully.");
        }
    }

    private void execute() {
        for (Pair<WrappedRunnable, Long> periodicalJob : this.jobs) {
            ((WrappedRunnable)periodicalJob.left).run();
        }
    }

    public synchronized void stop() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
            LOGGER.info("Active load periodical jobs executor is stopped successfully.");
        }
    }
}

