/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class Range
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=884");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=885");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=886");
    private final Double low;
    private final Double high;

    public Range(Double low, Double high) {
        this.low = low;
        this.high = high;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public Double getLow() {
        return this.low;
    }

    public Double getHigh() {
        return this.high;
    }

    protected Range(RangeBuilder<?, ?> b) {
        super(b);
        this.low = ((RangeBuilder)b).low;
        this.high = ((RangeBuilder)b).high;
    }

    public static RangeBuilder<?, ?> builder() {
        return new RangeBuilderImpl();
    }

    public RangeBuilder<?, ?> toBuilder() {
        return new RangeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$low = this.getLow();
        Double other$low = other.getLow();
        if (this$low == null ? other$low != null : !((Object)this$low).equals(other$low)) {
            return false;
        }
        Double this$high = this.getHigh();
        Double other$high = other.getHigh();
        return !(this$high == null ? other$high != null : !((Object)this$high).equals(other$high));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Range;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $low = this.getLow();
        result = result * 59 + ($low == null ? 43 : ((Object)$low).hashCode());
        Double $high = this.getHigh();
        result = result * 59 + ($high == null ? 43 : ((Object)$high).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Range(low=" + this.getLow() + ", high=" + this.getHigh() + ")";
    }

    private static final class RangeBuilderImpl
    extends RangeBuilder<Range, RangeBuilderImpl> {
        private RangeBuilderImpl() {
        }

        @Override
        protected RangeBuilderImpl self() {
            return this;
        }

        @Override
        public Range build() {
            return new Range(this);
        }
    }

    public static abstract class RangeBuilder<C extends Range, B extends RangeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private Double low;
        private Double high;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RangeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(Range instance, RangeBuilder<?, ?> b) {
            b.low(instance.low);
            b.high(instance.high);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B low(Double low) {
            this.low = low;
            return (B)this.self();
        }

        public B high(Double high) {
            this.high = high;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Range.RangeBuilder(super=" + super.toString() + ", low=" + this.low + ", high=" + this.high + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<Range> {
        @Override
        public Class<Range> getType() {
            return Range.class;
        }

        @Override
        public Range decode(SerializationContext context, UaDecoder decoder) {
            Double low = decoder.readDouble("Low");
            Double high = decoder.readDouble("High");
            return new Range(low, high);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, Range value) {
            encoder.writeDouble("Low", value.getLow());
            encoder.writeDouble("High", value.getHigh());
        }
    }
}

