/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr.PageIndexSortBuckets;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr.SchemaPageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagePool {
    private static final Logger logger = LoggerFactory.getLogger(PagePool.class);
    private final Map<Integer, ISchemaPage> pageInstCache = Collections.synchronizedMap(new LinkedHashMap(SchemaFileConfig.PAGE_CACHE_SIZE, 1.0f, true));
    private final Lock cacheLock;
    private final Condition cacheFull;
    private final PageIndexSortBuckets pageIndexBuckets = new PageIndexSortBuckets(SchemaFileConfig.SEG_SIZE_LST, this.pageInstCache);

    PagePool() {
        this.cacheLock = new ReentrantLock();
        this.cacheFull = this.cacheLock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cacheGuardian() {
        this.cacheLock.lock();
        try {
            while (this.pageInstCache.size() > SchemaFileConfig.PAGE_CACHE_SIZE) {
                try {
                    Iterator<ISchemaPage> iterator = this.pageInstCache.values().iterator();
                    int pageSizeLimit = SchemaFileConfig.PAGE_CACHE_SIZE;
                    int size = this.pageInstCache.size();
                    while (iterator.hasNext()) {
                        ISchemaPage p = iterator.next();
                        if (size <= pageSizeLimit) break;
                        if (p.getRefCnt().get() != 0) continue;
                        iterator.remove();
                        --size;
                    }
                    if (this.pageInstCache.size() <= SchemaFileConfig.PAGE_CACHE_SIZE) continue;
                    this.cacheFull.await();
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupted during page cache eviction. Consider increasing cache size, reducing concurrency, or extending timeout");
                }
            }
            return;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public void put(ISchemaPage page) {
        this.pageInstCache.put(page.getPageIndex(), page);
    }

    public void lock() {
        this.cacheLock.lock();
    }

    public void unlock() {
        this.cacheLock.unlock();
    }

    public ISchemaPage get(int index) {
        return this.pageInstCache.get(index);
    }

    public ISchemaPage getNearestFitPage(short expectedSize) {
        return this.pageIndexBuckets.getNearestFitPage(expectedSize, true);
    }

    public void remove(int index) {
        this.pageInstCache.remove(index);
    }

    public void clear() {
        this.pageInstCache.clear();
    }

    public void appendBucketIndex(SchemaPageContext cxt) {
        cxt.appendBucketIndex(this.pageIndexBuckets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseReferent(SchemaPageContext cxt) {
        for (ISchemaPage p : cxt.referredPages.values()) {
            p.decrementAndGetRefCnt();
        }
        if (this.pageInstCache.size() > SchemaFileConfig.PAGE_CACHE_SIZE) {
            this.cacheLock.lock();
            try {
                for (ISchemaPage p : cxt.referredPages.values()) {
                    if (p.getRefCnt().get() != 0 || this.pageInstCache.get(p.getPageIndex()) != p) continue;
                    this.pageInstCache.remove(p.getPageIndex());
                }
                if (this.pageInstCache.size() <= SchemaFileConfig.PAGE_CACHE_SIZE) {
                    this.cacheFull.signal();
                }
            }
            finally {
                this.cacheLock.unlock();
            }
        }
    }
}

