/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.DeviceInfo;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.TsFileResourceCandidate;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.tsfile.file.metadata.IDeviceID;

public class CrossSpaceCompactionCandidate {
    private List<TsFileResourceCandidate> seqFiles;
    private List<TsFileResourceCandidate> unseqFiles;
    private int nextUnseqFileIndex;
    private CrossCompactionTaskResourceSplit nextSplit;
    private long ttlLowerBound = Long.MIN_VALUE;
    private CompactionScheduleContext context = null;

    public CrossSpaceCompactionCandidate(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles) {
        this.init(seqFiles, unseqFiles, null);
    }

    public CrossSpaceCompactionCandidate(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, long ttlLowerBound) {
        this(seqFiles, unseqFiles, ttlLowerBound, null);
    }

    public CrossSpaceCompactionCandidate(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, long ttlLowerBound, CompactionScheduleContext context) {
        this.ttlLowerBound = ttlLowerBound;
        this.init(seqFiles, unseqFiles, context);
    }

    private void init(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, CompactionScheduleContext context) {
        this.context = context;
        this.seqFiles = this.copySeqResource(seqFiles);
        this.unseqFiles = this.filterUnseqResource(unseqFiles);
        this.nextUnseqFileIndex = 0;
    }

    public boolean hasNextSplit() throws IOException {
        if (this.nextUnseqFileIndex >= this.unseqFiles.size()) {
            return false;
        }
        return this.prepareNextSplit();
    }

    public CrossCompactionTaskResourceSplit nextSplit() {
        return this.nextSplit;
    }

    private boolean prepareNextSplit() throws IOException {
        TsFileResourceCandidate unseqFile = this.unseqFiles.get(this.nextUnseqFileIndex);
        CrossCompactionTaskResourceSplit tmpSplit = new CrossCompactionTaskResourceSplit(unseqFile);
        if (!unseqFile.hasDetailedDeviceInfo()) {
            return false;
        }
        Iterator<DeviceInfo> it = unseqFile.getDeviceInfoIterator();
        while (it.hasNext()) {
            DeviceInfo unseqDeviceInfo = it.next();
            IDeviceID deviceId = unseqDeviceInfo.deviceId;
            boolean atLeastOneSeqFileSelected = false;
            TsFileResourceCandidate previousSeqFile = null;
            for (TsFileResourceCandidate seqFile : this.seqFiles) {
                if (!(seqFile.isValidCandidate && seqFile.hasDetailedDeviceInfo() || !seqFile.mayHasOverlapWithUnseqFile(unseqDeviceInfo))) {
                    return false;
                }
                if (!seqFile.containsDevice(deviceId)) continue;
                DeviceInfo seqDeviceInfo = seqFile.getDeviceInfoById(deviceId);
                if (seqFile.unsealed() && unseqDeviceInfo.endTime >= seqDeviceInfo.startTime) {
                    return false;
                }
                if (unseqDeviceInfo.endTime <= seqDeviceInfo.endTime) {
                    tmpSplit.addSeqFileIfNotSelected(seqFile);
                    seqFile.markAsSelected();
                    atLeastOneSeqFileSelected = true;
                    break;
                }
                if (unseqDeviceInfo.startTime <= seqDeviceInfo.endTime) {
                    tmpSplit.addSeqFileIfNotSelected(seqFile);
                    seqFile.markAsSelected();
                    atLeastOneSeqFileSelected = true;
                    continue;
                }
                if (seqFile.unsealed()) continue;
                previousSeqFile = seqFile;
            }
            if (atLeastOneSeqFileSelected || previousSeqFile == null) continue;
            if (!previousSeqFile.isValidCandidate) {
                return false;
            }
            tmpSplit.addSeqFileIfNotSelected(previousSeqFile);
            previousSeqFile.markAsSelected();
        }
        unseqFile.markAsSelected();
        this.nextSplit = tmpSplit;
        ++this.nextUnseqFileIndex;
        return true;
    }

    private List<TsFileResourceCandidate> copySeqResource(List<TsFileResource> seqFiles) {
        ArrayList<TsFileResourceCandidate> ret = new ArrayList<TsFileResourceCandidate>();
        for (TsFileResource resource : seqFiles) {
            ret.add(new TsFileResourceCandidate(resource, this.context));
        }
        return ret;
    }

    private List<TsFileResourceCandidate> filterUnseqResource(List<TsFileResource> unseqResources) {
        ArrayList<TsFileResourceCandidate> ret = new ArrayList<TsFileResourceCandidate>();
        for (TsFileResource resource : unseqResources) {
            if (resource.getStatus() != TsFileResourceStatus.NORMAL) break;
            if (!resource.stillLives(this.ttlLowerBound)) continue;
            ret.add(new TsFileResourceCandidate(resource, this.context));
        }
        return ret;
    }

    public List<TsFileResource> getSeqFiles() {
        return this.seqFiles.stream().map(tsFileResourceCandidate -> tsFileResourceCandidate.resource).collect(Collectors.toList());
    }

    public List<TsFileResourceCandidate> getSeqFileCandidates() {
        return this.seqFiles;
    }

    public List<TsFileResourceCandidate> getUnseqFileCandidates() {
        return this.unseqFiles;
    }

    public List<TsFileResource> getUnseqFiles() {
        return this.unseqFiles.stream().map(tsFileResourceCandidate -> tsFileResourceCandidate.resource).collect(Collectors.toList());
    }

    public static class CrossCompactionTaskResourceSplit {
        public TsFileResourceCandidate unseqFile;
        public List<TsFileResourceCandidate> seqFiles;
        public boolean atLeastOneSeqFileSelected;

        public CrossCompactionTaskResourceSplit(TsFileResourceCandidate unseqFile) {
            this.unseqFile = unseqFile;
            this.seqFiles = new ArrayList<TsFileResourceCandidate>();
            this.atLeastOneSeqFileSelected = false;
        }

        public CrossCompactionTaskResourceSplit(TsFileResourceCandidate unseqFile, List<TsFileResourceCandidate> seqFiles, boolean atLeastOneSeqFileSelected) {
            this.unseqFile = unseqFile;
            this.seqFiles = seqFiles;
            this.atLeastOneSeqFileSelected = atLeastOneSeqFileSelected;
        }

        public void addSeqFileIfNotSelected(TsFileResourceCandidate seqFile) {
            if (!seqFile.selected) {
                this.seqFiles.add(seqFile);
            }
            this.atLeastOneSeqFileSelected = true;
        }
    }
}

