/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.poll;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class FileSealPayload
implements SubscriptionPollPayload {
    private transient String fileName;
    private transient long fileLength;

    public String getFileName() {
        return this.fileName;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public FileSealPayload() {
    }

    public FileSealPayload(String fileName, long fileLength) {
        this.fileName = fileName;
        this.fileLength = fileLength;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.fileName, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.fileLength, (OutputStream)stream);
    }

    @Override
    public SubscriptionPollPayload deserialize(ByteBuffer buffer) {
        this.fileName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.fileLength = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FileSealPayload that = (FileSealPayload)obj;
        return Objects.equals(this.fileName, that.fileName) && Objects.equals(this.fileLength, that.fileLength);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.fileLength);
    }

    public String toString() {
        return "FileSealPayload{fileName=" + this.fileName + ", fileLength=" + this.fileLength + "}";
    }
}

